/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.util.IMessageHandler;

public class ObjectArrayDataSet
implements IDataSet {
    private Object[][] _src;
    private DataSetDefinition _dsDef;
    private Object[] _curRow;
    private int _curIndex = -1;
    private int _columnCount;

    public ObjectArrayDataSet(Object[] src) throws DataSetException {
        this(ObjectArrayDataSet.convert(src));
    }

    public ObjectArrayDataSet(Object[][] src) throws DataSetException {
        if (src == null) {
            throw new IllegalArgumentException("Null Object[][] passed");
        }
        this._src = src;
        for (int i = 0; i < src.length; ++i) {
            if (src[i] == null || src[i].length <= this._columnCount) continue;
            this._columnCount = src[i].length;
        }
        this._dsDef = new DataSetDefinition(this.createColumnDefinitions());
    }

    @Override
    public final int getColumnCount() {
        return this._columnCount;
    }

    @Override
    public DataSetDefinition getDataSetDefinition() {
        return this._dsDef;
    }

    @Override
    public synchronized boolean next(IMessageHandler msgHandler) {
        this._curRow = null;
        if (this._src.length > this._curIndex + 1) {
            this._curRow = this._src[++this._curIndex];
            return true;
        }
        return false;
    }

    @Override
    public synchronized Object get(int columnIndex) {
        if (this._curRow != null && columnIndex < this._curRow.length) {
            return this._curRow[columnIndex];
        }
        return null;
    }

    private ColumnDisplayDefinition[] createColumnDefinitions() {
        int columnCount = this.getColumnCount();
        ColumnDisplayDefinition[] columnDefs = new ColumnDisplayDefinition[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnDefs[i] = new ColumnDisplayDefinition(100, " ");
        }
        return columnDefs;
    }

    private static Object[][] convert(Object[] src) {
        Object[][] dsInfo = new Object[src.length][1];
        for (int i = 0; i < src.length; ++i) {
            dsInfo[i][0] = src[i];
        }
        return dsInfo;
    }
}

