/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.border.Border;

public class TimePanel
extends JLabel
implements ActionListener {
    private Timer _timer;
    private DateFormat _fmt = DateFormat.getTimeInstance(1);
    private Dimension _prefSize;
    private Calendar _calendar = Calendar.getInstance();

    public TimePanel() {
        super("", 0);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._timer = new Timer(1000, this);
        this._timer.start();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._timer != null) {
            this._timer.stop();
            this._timer = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this._calendar.setTimeInMillis(System.currentTimeMillis());
        this.setText(this._fmt.format(this._calendar.getTime()));
    }

    @Override
    public Dimension getPreferredSize() {
        if (null == this._prefSize) {
            Insets ins;
            this._prefSize = new Dimension();
            this._prefSize.height = 20;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            Calendar cal = Calendar.getInstance();
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            this._prefSize.width = fm.stringWidth(this._fmt.format(cal.getTime()));
            Border border = this.getBorder();
            if (border != null && (ins = border.getBorderInsets(this)) != null) {
                this._prefSize.width += ins.left + ins.right;
            }
            if ((ins = this.getInsets()) != null) {
                this._prefSize.width += ins.left + ins.right + 20;
            }
        }
        return this._prefSize;
    }
}

