/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.FontSelector;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.RListSelectionModel;
import org.fife.ui.RScrollPane;
import org.fife.ui.UIUtil;
import org.fife.ui.rsyntaxtextarea.BackgroundDialog;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rtextarea.RTextArea;

public class RSyntaxTextAreaOptionPanel
extends OptionsDialogPanel
implements ActionListener,
PropertyChangeListener,
ListSelectionListener {
    private FontSelector mainFontSelector;
    private JTextField mainBackgroundField;
    private JButton mainBackgroundButton;
    private BackgroundDialog backgroundDialog;
    private Object background;
    private String bgImageFileName;
    private JPanel syntaxPanel;
    private JList syntaxList;
    private DefaultListModel syntaxListModel;
    private FontSelector fontSelector;
    private RColorSwatchesButton foregroundButton;
    private JCheckBox fgCheckBox;
    private JCheckBox bgCheckBox;
    private RColorSwatchesButton backgroundButton;
    private JComboBox sampleCombo;
    private RSyntaxTextArea sampleArea;
    private SyntaxScheme colorScheme;
    private boolean isSettingStyle;
    private static final String DEFAULTS_RESTORED = "RSTAOpts.defaultsRestored";
    private static final String SYNTAX_COLOR_PROPERTY = "RSTAOpts.syntaxColor";
    private static final String SYNTAX_FONT_PROPERTY = "RSTAOpts.syntaxFont";
    private static final String UNKNOWN_PROPERTY = "RSTAOpts.unknown";
    private static final String[] SAMPLES = new String[]{"previewJava.txt", "previewPerl.txt", "previewXml.txt"};
    private static final String[] SAMPLE_STYLES = new String[]{"text/java", "text/perl", "text/xml"};

    public RSyntaxTextAreaOptionPanel() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        ResourceBundle msg = ResourceBundle.getBundle("org.fife.ui.rsyntaxtextarea.OptionPanel");
        this.setName(msg.getString("Title"));
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box contentPane = Box.createVerticalBox();
        this.add(contentPane, "North");
        SpringLayout sl = new SpringLayout();
        JPanel springPanel = new JPanel(sl);
        springPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Font")));
        this.mainFontSelector = new FontSelector(1);
        this.mainFontSelector.setColorSelectable(true);
        this.mainFontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.mainFontSelector.addPropertyChangeListener("fontColor", (PropertyChangeListener)this);
        JLabel mfsLabel = new JLabel(msg.getString("Font"));
        mfsLabel.setLabelFor((Component)this.mainFontSelector);
        JLabel bgLabel = new JLabel(msg.getString("Background"));
        this.mainBackgroundField = new JTextField(20);
        this.mainBackgroundField.setEditable(false);
        this.mainBackgroundButton = new JButton(msg.getString("Change"));
        this.mainBackgroundButton.setActionCommand("BackgroundButton");
        this.mainBackgroundButton.addActionListener(this);
        bgLabel.setLabelFor(this.mainBackgroundButton);
        Box bgRestPanel = this.createHorizontalBox();
        bgRestPanel.add(this.mainBackgroundField);
        bgRestPanel.add(Box.createHorizontalStrut(5));
        bgRestPanel.add(this.mainBackgroundButton);
        if (orientation.isLeftToRight()) {
            springPanel.add(mfsLabel);
            springPanel.add((Component)this.mainFontSelector);
            springPanel.add(bgLabel);
            springPanel.add(bgRestPanel);
        } else {
            springPanel.add((Component)this.mainFontSelector);
            springPanel.add(mfsLabel);
            springPanel.add(bgRestPanel);
            springPanel.add(bgLabel);
        }
        UIUtil.makeSpringCompactGrid((Container)springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        contentPane.add(springPanel);
        contentPane.add(Box.createVerticalStrut(5));
        this.syntaxPanel = new JPanel(new BorderLayout());
        this.syntaxPanel.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("FontsAndColors")));
        this.syntaxListModel = new DefaultListModel();
        this.syntaxList = new JList(this.syntaxListModel);
        this.syntaxList.setSelectionModel((ListSelectionModel)new RListSelectionModel());
        this.syntaxList.addListSelectionListener(this);
        this.syntaxList.setVisibleRowCount(10);
        this.syntaxListModel.addElement(msg.getString("Style.Comment.EndOfLine"));
        this.syntaxListModel.addElement(msg.getString("Style.Comment.Multiline"));
        this.syntaxListModel.addElement(msg.getString("Style.Comment.Documentation"));
        this.syntaxListModel.addElement(msg.getString("Style.Comment.Keyword"));
        this.syntaxListModel.addElement(msg.getString("Style.Comment.Markup"));
        this.syntaxListModel.addElement(msg.getString("Style.ReservedWord"));
        this.syntaxListModel.addElement(msg.getString("Style.ReservedWord2"));
        this.syntaxListModel.addElement(msg.getString("Style.Function"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Boolean"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Integer"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Float"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Hex"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.String"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Char"));
        this.syntaxListModel.addElement(msg.getString("Style.Literal.Backquote"));
        this.syntaxListModel.addElement(msg.getString("Style.DataType"));
        this.syntaxListModel.addElement(msg.getString("Style.Variable"));
        this.syntaxListModel.addElement(msg.getString("Style.RegularExpression"));
        this.syntaxListModel.addElement(msg.getString("Style.Annotation"));
        this.syntaxListModel.addElement("<html><b>" + msg.getString("Style.Identifier.PlainText"));
        this.syntaxListModel.addElement(msg.getString("Style.Whitespace"));
        this.syntaxListModel.addElement(msg.getString("Style.Separator"));
        this.syntaxListModel.addElement(msg.getString("Style.Operator"));
        this.syntaxListModel.addElement(msg.getString("Style.Preprocessor"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.Delimiter"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.TagName"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.Attribute"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.AttributeValue"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.Comment"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.DTD"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.ProcessingInstruction"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.CDataDelimiter"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.CData"));
        this.syntaxListModel.addElement(msg.getString("Style.MarkupTag.EntityReference"));
        this.syntaxListModel.addElement(msg.getString("Style.Error.Identifier"));
        this.syntaxListModel.addElement(msg.getString("Style.Error.Number"));
        this.syntaxListModel.addElement(msg.getString("Style.Error.String"));
        this.syntaxListModel.addElement(msg.getString("Style.Error.Char"));
        this.syntaxPanel.add((Component)new RScrollPane((Component)this.syntaxList), "Before");
        Box propertiesPanel = Box.createVerticalBox();
        this.fontSelector = new FontSelector(2);
        this.fontSelector.setUnderlineSelectable(true);
        this.fontSelector.addPropertyChangeListener("font", (PropertyChangeListener)this);
        this.fontSelector.addPropertyChangeListener("enabled", (PropertyChangeListener)this);
        Box temp = this.createHorizontalBox();
        temp.add((Component)this.fontSelector);
        temp.add(Box.createHorizontalStrut(5));
        propertiesPanel.add(temp);
        propertiesPanel.add(Box.createVerticalStrut(8));
        temp = this.createHorizontalBox();
        temp.setAlignmentX(0.0f);
        this.fgCheckBox = new JCheckBox(msg.getString("Foreground"));
        this.fgCheckBox.setActionCommand("fgCheckBox");
        this.fgCheckBox.addActionListener(this);
        this.foregroundButton = new RColorSwatchesButton(Color.BLACK);
        this.foregroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        temp.add(this.fgCheckBox);
        temp.add((Component)this.foregroundButton);
        temp.add(Box.createHorizontalGlue());
        propertiesPanel.add(temp);
        propertiesPanel.add(Box.createVerticalStrut(8));
        temp = this.createHorizontalBox();
        temp.setAlignmentX(0.0f);
        this.bgCheckBox = new JCheckBox(msg.getString("Background"));
        this.bgCheckBox.setActionCommand("bgCheckBox");
        this.bgCheckBox.addActionListener(this);
        this.backgroundButton = new RColorSwatchesButton(Color.BLACK);
        this.backgroundButton.addPropertyChangeListener("RColorButton.colorChanged", (PropertyChangeListener)this);
        temp.add(this.bgCheckBox);
        temp.add((Component)this.backgroundButton);
        temp.add(Box.createHorizontalGlue());
        propertiesPanel.add(temp);
        propertiesPanel.add(Box.createVerticalGlue());
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add((Component)propertiesPanel, "North");
        this.syntaxPanel.add(temp2);
        contentPane.add(this.syntaxPanel);
        temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("Preview")));
        Box horizBox = this.createHorizontalBox();
        horizBox.add(new JLabel(msg.getString("SampleTextLabel")));
        horizBox.add(Box.createHorizontalStrut(5));
        String[] samples = new String[]{"Java", "Perl", "XML"};
        this.sampleCombo = new JComboBox<String>(samples);
        this.sampleCombo.setEditable(false);
        this.sampleCombo.addActionListener(this);
        horizBox.add(this.sampleCombo);
        horizBox.add(Box.createHorizontalGlue());
        this.addLeftAligned(temp, horizBox, 3);
        this.sampleArea = RSyntaxTextAreaOptionPanel.createSampleTextArea();
        temp.add((Component)new RScrollPane((Component)this.sampleArea));
        temp.add(Box.createVerticalStrut(3));
        Box rdPanel = this.createHorizontalBox();
        JButton rdButton = new JButton(msg.getString("RestoreDefaults"));
        rdButton.setActionCommand("RestoreDefaults");
        rdButton.addActionListener(this);
        rdPanel.add(rdButton);
        rdPanel.add(Box.createHorizontalGlue());
        JPanel advancedPanel = new JPanel(new BorderLayout());
        advancedPanel.add(temp);
        advancedPanel.add((Component)rdPanel, "South");
        contentPane.add(advancedPanel);
        this.applyComponentOrientation(orientation);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("BackgroundButton")) {
            if (this.backgroundDialog == null) {
                this.backgroundDialog = new BackgroundDialog((Dialog)this.getOptionsDialog());
            }
            this.backgroundDialog.initializeData(this.background, this.bgImageFileName);
            this.backgroundDialog.setVisible(true);
            Object newBG = this.backgroundDialog.getChosenBackground();
            if (newBG != null && !newBG.equals(this.background)) {
                Object oldBG = this.background;
                this.setBackgroundObject(newBG);
                this.setBackgroundImageFileName(this.backgroundDialog.getCurrentImageFileName());
                this.refreshSyntaxHighlightingSection();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(UNKNOWN_PROPERTY, oldBG, newBG);
            }
        } else if ("fgCheckBox".equals(command) && !this.isSettingStyle) {
            boolean selected = this.fgCheckBox.isSelected();
            this.foregroundButton.setEnabled(selected);
            int i = this.syntaxList.getSelectedIndex();
            this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).foreground = selected ? this.foregroundButton.getColor() : null;
            this.refreshSyntaxHighlightingSection();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(SYNTAX_COLOR_PROPERTY, null, null);
        } else if ("bgCheckBox".equals(command) && !this.isSettingStyle) {
            boolean selected = this.bgCheckBox.isSelected();
            this.backgroundButton.setEnabled(selected);
            int i = this.syntaxList.getSelectedIndex();
            this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).background = selected ? this.backgroundButton.getColor() : null;
            this.refreshSyntaxHighlightingSection();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(SYNTAX_COLOR_PROPERTY, null, null);
        } else if (this.sampleCombo == e.getSource()) {
            this.refreshDisplayedSample();
        } else if ("RestoreDefaults".equals(command)) {
            Font defaultFont = RTextArea.getDefaultFont();
            Color defaultForeground = RTextArea.getDefaultForeground();
            SyntaxScheme currentScheme = this.getSyntaxScheme();
            SyntaxScheme defaultScheme = new SyntaxScheme(true);
            if (!(this.getTextAreaFont().equals(defaultFont) && !this.getUnderline() && this.getTextAreaForeground().equals(defaultForeground) && Color.WHITE.equals(this.background) && currentScheme.equals(defaultScheme))) {
                this.setBackgroundObject(Color.WHITE);
                this.setTextAreaFont(defaultFont, false);
                this.setTextAreaForeground(defaultForeground);
                this.setSyntaxScheme(defaultScheme);
                this.refreshSyntaxHighlightingSection();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(DEFAULTS_RESTORED, null, null);
                this.valueChanged(null);
            }
        }
    }

    private static final RSyntaxTextArea createSampleTextArea() {
        RSyntaxTextArea textArea = new RSyntaxTextArea(10, 40);
        textArea.setHighlightCurrentLine(false);
        textArea.setAntiAliasingEnabled(true);
        textArea.setSyntaxEditingStyle("text/java");
        textArea.setPopupMenu(null);
        return textArea;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setTextAreaForeground(this.getTextAreaForeground());
        mainView.setTextAreaFont(this.getTextAreaFont(), this.getUnderline());
        mainView.setBackgroundObject(this.getBackgroundObject());
        mainView.setBackgroundImageFileName(this.getBackgroundImageFileName());
        rtext.setSyntaxScheme(this.getSyntaxScheme());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    public String getBackgroundImageFileName() {
        return this.bgImageFileName;
    }

    public Object getBackgroundObject() {
        return this.background;
    }

    protected static String getPreviewText(boolean underline) {
        return underline ? "<html><u>Hello, world!</u>" : "Hello, world!";
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.colorScheme;
    }

    public Font getTextAreaFont() {
        return this.mainFontSelector.getDisplayedFont();
    }

    public Color getTextAreaForeground() {
        return this.mainFontSelector.getFontColor();
    }

    public JComponent getTopJComponent() {
        return this.mainFontSelector;
    }

    public boolean getUnderline() {
        return this.mainFontSelector.getUnderline();
    }

    private static final int indexToStyle(int index) {
        return index + 1;
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (this.isSettingStyle) {
            return;
        }
        Object source = e.getSource();
        if (source == this.mainFontSelector) {
            this.sampleArea.setFont(this.mainFontSelector.getDisplayedFont());
            this.sampleArea.setForeground(this.mainFontSelector.getFontColor());
            this.refreshSyntaxHighlightingSection();
            this.valueChanged(null);
            this.hasUnsavedChanges = true;
            this.firePropertyChange(UNKNOWN_PROPERTY, false, true);
        } else if (source == this.fontSelector && this.colorScheme != null) {
            int i = this.syntaxList.getSelectedIndex();
            Style style = this.colorScheme.getStyle(RSyntaxTextAreaOptionPanel.indexToStyle(i));
            style.fontMetrics = null;
            if (this.fontSelector.isToggledOn()) {
                style.font = this.fontSelector.getDisplayedFont();
                style.underline = this.fontSelector.getUnderline();
            } else {
                style.font = null;
                style.underline = false;
            }
            this.refreshSyntaxHighlightingSection();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(SYNTAX_FONT_PROPERTY, e.getOldValue(), e.getNewValue());
        } else if (source == this.foregroundButton && this.colorScheme != null) {
            Color fg = null;
            fg = this.foregroundButton.isEnabled() ? this.foregroundButton.getColor() : this.getTextAreaForeground();
            if (!this.isSettingStyle) {
                int i = this.syntaxList.getSelectedIndex();
                this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).foreground = fg;
                this.refreshSyntaxHighlightingSection();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(SYNTAX_COLOR_PROPERTY, e.getOldValue(), e.getNewValue());
            }
        } else if (source == this.backgroundButton && this.colorScheme != null) {
            Color bg = null;
            if (this.backgroundButton.isEnabled()) {
                bg = this.backgroundButton.getColor();
            } else {
                Object bgObj = this.getBackgroundObject();
                Color color = bg = bgObj instanceof Color ? (Color)bgObj : Color.WHITE;
            }
            if (!this.isSettingStyle) {
                int i = this.syntaxList.getSelectedIndex();
                this.colorScheme.getStyle((int)RSyntaxTextAreaOptionPanel.indexToStyle((int)i)).background = bg;
                this.refreshSyntaxHighlightingSection();
                this.hasUnsavedChanges = true;
                this.firePropertyChange(SYNTAX_COLOR_PROPERTY, e.getOldValue(), e.getNewValue());
            }
        } else {
            this.refreshSyntaxHighlightingSection();
            this.hasUnsavedChanges = true;
            this.firePropertyChange(UNKNOWN_PROPERTY, e.getOldValue(), e.getNewValue());
        }
    }

    private void refreshDisplayedSample() {
        int index = this.sampleCombo.getSelectedIndex();
        if (index < 0 || index > SAMPLES.length) {
            index = 0;
        }
        InputStream in = this.getClass().getResourceAsStream(SAMPLES[index]);
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        try {
            this.sampleArea.read(br, null);
            br.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.sampleArea.setCaretPosition(0);
        this.sampleArea.setSyntaxEditingStyle(SAMPLE_STYLES[index]);
        this.sampleArea.discardAllEdits();
    }

    private void refreshSyntaxHighlightingSection() {
        this.sampleArea.repaint();
    }

    private void setBackgroundImageFileName(String name) {
        this.bgImageFileName = name;
        if (this.bgImageFileName != null) {
            this.mainBackgroundField.setText(this.bgImageFileName);
        }
    }

    private void setBackgroundObject(Object background) {
        if (background instanceof Color) {
            String s = background.toString();
            this.mainBackgroundField.setText(s.substring(s.indexOf(91)));
        } else if (!(background instanceof Image)) {
            throw new IllegalArgumentException("Background must be either a Color or an Image");
        }
        this.background = background;
        Object sampleBG = background;
        if (sampleBG instanceof Image) {
            RText parent = (RText)((Object)this.getOptionsDialog().getParent());
            sampleBG = RTextUtilities.getTranslucentImage(parent, (Image)sampleBG, parent.getMainView().getBackgroundImageAlpha());
        }
        this.sampleArea.setBackgroundObject(sampleBG);
        this.refreshSyntaxHighlightingSection();
    }

    public void setSyntaxScheme(SyntaxScheme ss) {
        this.colorScheme = (SyntaxScheme)ss.clone();
        this.syntaxList.setSelectedIndex(0);
        this.sampleArea.setSyntaxScheme(this.colorScheme);
        this.valueChanged(null);
    }

    private void setTextAreaFont(Font font, boolean underline) {
        this.mainFontSelector.setDisplayedFont(font, underline);
        this.sampleArea.setFont(font);
        this.refreshDisplayedSample();
    }

    private void setTextAreaForeground(Color fg) {
        this.mainFontSelector.setFontColor(fg);
        this.sampleArea.setForeground(fg);
        this.refreshDisplayedSample();
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setTextAreaForeground(mainView.getTextAreaForeground());
        this.setTextAreaFont(mainView.getTextAreaFont(), mainView.getTextAreaUnderline());
        this.setBackgroundObject(mainView.getBackgroundObject());
        this.setBackgroundImageFileName(mainView.getBackgroundImageFileName());
        this.setSyntaxScheme(rtext.getSyntaxScheme());
        if (this.sampleArea.getDocument().getLength() == 0) {
            this.refreshDisplayedSample();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.backgroundDialog != null) {
            SwingUtilities.updateComponentTreeUI(this.backgroundDialog);
            this.backgroundDialog.updateUI();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int index = this.syntaxList.getSelectedIndex();
        index = RSyntaxTextAreaOptionPanel.indexToStyle(index);
        this.isSettingStyle = true;
        Font font = null;
        boolean underline = false;
        Style style = this.colorScheme.getStyle(index);
        if (style.font != null) {
            font = style.font;
            underline = style.underline;
        } else {
            font = this.getTextAreaFont();
            underline = this.getUnderline();
        }
        this.fontSelector.setToggledOn(style.font != null);
        this.fontSelector.setDisplayedFont(font, underline);
        boolean notNull = style.foreground != null;
        this.fgCheckBox.setSelected(notNull);
        this.foregroundButton.setEnabled(notNull);
        this.foregroundButton.setColor(notNull ? style.foreground : this.getTextAreaForeground());
        notNull = style.background != null;
        this.bgCheckBox.setSelected(notNull);
        this.backgroundButton.setEnabled(notNull);
        if (style.background != null) {
            this.backgroundButton.setColor(style.background);
        } else {
            Object parentBG = this.getBackgroundObject();
            if (parentBG instanceof Color) {
                this.backgroundButton.setColor((Color)parentBG);
            } else {
                this.backgroundButton.setColor(Color.WHITE);
            }
        }
        this.isSettingStyle = false;
    }
}

