//
// $Id: ObjectBase.h,v 1.8 2007/03/07 00:01:50 will_mason Exp $
//
// vi: set ft=objc:

/*
 * ObjectiveLib - a library of containers and algorithms for Objective-C
 *
 * Copyright (c) 2004-2007
 * Will Mason
 *
 * Portions:
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Copyright (c) 1996,1997
 * Silicon Graphics Computer Systems, Inc.
 *
 * Copyright (c) 1997
 * Moscow Center for SPARC Technology
 *
 * Copyright (c) 1999 
 * Boris Fomitchev
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * You may contact the author at will_mason@users.sourceforge.net.
 */

#if !defined(OBJECTBASE_OL_GUARD)
#define OBJECTBASE_OL_GUARD

#include <ObjectiveLib/Config.h>
#include <ObjectiveLib/Streamable.h>

#if defined(OL_NO_OPENSTEP)

#include <objc/Object.h>

@class OLConstantString;

#if defined(__NEXT_RUNTIME__)
/**
 * @category Object(OLComparison) ObjectBase.h ObjectiveLib/ObjectBase.h
 *
 * A category of the base class for comparison. This category is only defined when
 * using the Next runtime system. It is already a part of the GNU runtime.
 */
@interface Object (OLComparison)

/**
 * Compare this object to another one.
 *
 * @param other the object to which to compare this one
 * @return a value greater than, equal to, or less than zero accoringly as this object
 * is greater than, equal to, or less than @a other
 */
- (int) compare: (id)other;
@end
#endif

#else

#if defined(OL_GENERATING_DOCUMENTATION)
#include <Foundation/NSObject.h>
#else
#import <Foundation/NSObject.h>
#endif

#endif

#endif
