/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.circuitbreaker;

import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import org.apache.solr.util.circuitbreaker.CircuitBreaker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CPUCircuitBreaker
extends CircuitBreaker {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final boolean enabled;
    private final double cpuUsageThreshold;
    private static final ThreadLocal<Double> seenCPUUsage = ThreadLocal.withInitial(() -> 0.0);
    private static final ThreadLocal<Double> allowedCPUUsage = ThreadLocal.withInitial(() -> 0.0);

    public CPUCircuitBreaker(CircuitBreaker.CircuitBreakerConfig config) {
        super(config);
        this.enabled = config.getCpuCBEnabled();
        this.cpuUsageThreshold = config.getCpuCBThreshold();
    }

    @Override
    public boolean isTripped() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.enabled) {
            return false;
        }
        double localAllowedCPUUsage = this.getCpuUsageThreshold();
        double localSeenCPUUsage = this.calculateLiveCPUUsage();
        if (localSeenCPUUsage < 0.0) {
            if (log.isWarnEnabled()) {
                String msg = "Unable to get CPU usage";
                log.warn(msg);
            }
            return false;
        }
        allowedCPUUsage.set(localAllowedCPUUsage);
        seenCPUUsage.set(localSeenCPUUsage);
        return localSeenCPUUsage >= localAllowedCPUUsage;
    }

    @Override
    public String getDebugInfo() {
        if (seenCPUUsage.get() == 0.0 || seenCPUUsage.get() == 0.0) {
            log.warn("CPUCircuitBreaker's monitored values (seenCPUUSage, allowedCPUUsage) not set");
        }
        return "seenCPUUSage=" + seenCPUUsage.get() + " allowedCPUUsage=" + allowedCPUUsage.get();
    }

    @Override
    public String getErrorMessage() {
        return "CPU Circuit Breaker triggered as seen CPU usage is above allowed threshold.Seen CPU usage " + seenCPUUsage.get() + " and allocated threshold " + allowedCPUUsage.get();
    }

    public double getCpuUsageThreshold() {
        return this.cpuUsageThreshold;
    }

    protected double calculateLiveCPUUsage() {
        return operatingSystemMXBean.getSystemLoadAverage();
    }
}

