/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.tomcat.util.net.SocketWrapper;

public class BioServletInputStream
extends AbstractServletInputStream {
    private final InputStream inputStream;
    private ByteBuffer leftoverInput;

    public BioServletInputStream(SocketWrapper<Socket> wrapper, ByteBuffer leftoverInput) throws IOException {
        this.inputStream = wrapper.getSocket().getInputStream();
        if (leftoverInput != null) {
            this.leftoverInput = ByteBuffer.allocate(leftoverInput.remaining());
            this.leftoverInput.put(leftoverInput);
        }
    }

    @Override
    protected int doRead(boolean block, byte[] b, int off, int len) throws IOException {
        if (this.leftoverInput != null) {
            if (this.leftoverInput.remaining() < len) {
                len = this.leftoverInput.remaining();
            }
            this.leftoverInput.get(b, off, len);
            if (this.leftoverInput.remaining() == 0) {
                this.leftoverInput = null;
            }
            return len;
        }
        return this.inputStream.read(b, off, len);
    }

    @Override
    protected boolean doIsReady() {
        return true;
    }

    @Override
    protected void doClose() throws IOException {
        this.inputStream.close();
    }
}

