/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.sketch;

import edu.umd.marbl.mhap.sketch.HashUtils;
import edu.umd.marbl.mhap.sketch.Sketch;
import it.unimi.dsi.fastutil.ints.IntArrays;

public class BottomSketch
implements Sketch<BottomSketch> {
    private final int[] hashPositions;
    private static final long serialVersionUID = 9035607728472270206L;

    public BottomSketch(String str, int nGramSize, int k, boolean doReverseCompliment) {
        int iter;
        int[] hashes = HashUtils.computeSequenceHashes(str, nGramSize, doReverseCompliment);
        k = Math.min(k, hashes.length);
        int[] perm = new int[hashes.length];
        for (iter = 0; iter < hashes.length; ++iter) {
            perm[iter] = iter;
        }
        IntArrays.radixSortIndirect(perm, hashes, true);
        this.hashPositions = new int[k];
        for (iter = 0; iter < k; ++iter) {
            int index = perm[iter];
            this.hashPositions[iter] = hashes[index];
        }
    }

    public double jaccard(BottomSketch sh) {
        int k = Math.min(this.hashPositions.length, sh.hashPositions.length);
        int i = 0;
        int j = 0;
        int intersectCount = 0;
        for (int unionCount = 0; unionCount < k; ++unionCount) {
            if (this.hashPositions[i] < sh.hashPositions[j]) {
                ++i;
                continue;
            }
            if (this.hashPositions[i] > sh.hashPositions[j]) {
                ++j;
                continue;
            }
            ++intersectCount;
            ++i;
            ++j;
        }
        return (double)intersectCount / (double)k;
    }

    @Override
    public double similarity(BottomSketch sh) {
        return this.jaccard(sh);
    }
}

