/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.input.chain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;
import org.elasticsearch.xpack.core.watcher.input.ExecutableInput;
import org.elasticsearch.xpack.core.watcher.input.Input;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.input.chain.ChainInput;

public class ExecutableChainInput
extends ExecutableInput<ChainInput, ChainInput.Result> {
    private static final Logger logger = LogManager.getLogger(ExecutableChainInput.class);
    private List<Tuple<String, ExecutableInput>> inputs;

    public ExecutableChainInput(ChainInput input, List<Tuple<String, ExecutableInput>> inputs) {
        super((Input)input);
        this.inputs = inputs;
    }

    public ChainInput.Result execute(WatchExecutionContext ctx, Payload payload) {
        ArrayList<Tuple<String, Input.Result>> results = new ArrayList<Tuple<String, Input.Result>>();
        HashMap<String, Map> payloads = new HashMap<String, Map>();
        try {
            for (Tuple<String, ExecutableInput> tuple : this.inputs) {
                Input.Result result = ((ExecutableInput)tuple.v2()).execute(ctx, (Payload)new Payload.Simple(payloads));
                results.add((Tuple<String, Input.Result>)new Tuple((Object)((String)tuple.v1()), (Object)result));
                payloads.put((String)tuple.v1(), result.payload().data());
            }
            return new ChainInput.Result(results, (Payload)new Payload.Simple(payloads));
        }
        catch (Exception e) {
            logger.error("failed to execute [{}] input for watch [{}], reason [{}]", (Object)"chain", (Object)ctx.watch().id(), (Object)e.getMessage());
            return new ChainInput.Result(e);
        }
    }
}

