/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.parallel;

import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.parallel.ParallelProcessor;
import com.unboundid.util.parallel.Result;
import com.unboundid.util.parallel.ResultProcessor;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@InternalUseOnly
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AsynchronousParallelProcessor<I, O> {
    private final BlockingQueue<I> pendingQueue;
    private final ParallelProcessor<I, O> parallelProcessor;
    private final ResultProcessor<I, O> resultProcessor;
    private final InvokerThread invokerThread;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final AtomicReference<Throwable> invocationException = new AtomicReference();

    public AsynchronousParallelProcessor(BlockingQueue<I> pendingQueue, ParallelProcessor<I, O> parallelProcessor, ResultProcessor<I, O> resultProcessor) {
        this.pendingQueue = pendingQueue;
        this.parallelProcessor = parallelProcessor;
        this.resultProcessor = resultProcessor;
        this.invokerThread = new InvokerThread();
        this.invokerThread.start();
    }

    public AsynchronousParallelProcessor(BlockingQueue<I> pendingQueue, ParallelProcessor<I, O> parallelProcessor, BlockingQueue<Result<I, O>> outputQueue) {
        this(pendingQueue, parallelProcessor, new OutputEnqueuer(outputQueue));
    }

    public synchronized void submit(I input) throws InterruptedException {
        if (this.shutdown.get()) {
            throw new IllegalStateException("cannot call submit() after shutdown()");
        }
        Throwable resultProcessingError = this.invocationException.get();
        if (resultProcessingError != null) {
            this.shutdown();
            StaticUtils.throwErrorOrRuntimeException(resultProcessingError);
        }
        this.pendingQueue.put(input);
    }

    public synchronized void shutdown() throws InterruptedException {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        this.invokerThread.join();
        this.parallelProcessor.shutdown();
    }

    private final class InvokerThread
    extends Thread {
        private InvokerThread() {
            super("Asynchronous Parallel Processor");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            while (!AsynchronousParallelProcessor.this.shutdown.get() || !AsynchronousParallelProcessor.this.pendingQueue.isEmpty()) {
                try {
                    Object item = AsynchronousParallelProcessor.this.pendingQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (item == null) continue;
                    ArrayList items = new ArrayList(1 + AsynchronousParallelProcessor.this.pendingQueue.size());
                    items.add(item);
                    AsynchronousParallelProcessor.this.pendingQueue.drainTo(items);
                    ArrayList results = AsynchronousParallelProcessor.this.parallelProcessor.processAll(items);
                    for (Result result : results) {
                        AsynchronousParallelProcessor.this.resultProcessor.processResult(result);
                    }
                }
                catch (Throwable e) {
                    Debug.debugException(e);
                    AsynchronousParallelProcessor.this.invocationException.compareAndSet(null, e);
                }
            }
        }
    }

    private static final class OutputEnqueuer<I, O>
    implements ResultProcessor<I, O> {
        private final BlockingQueue<Result<I, O>> outputQueue;

        private OutputEnqueuer(BlockingQueue<Result<I, O>> outputQueue) {
            this.outputQueue = outputQueue;
        }

        @Override
        public void processResult(Result<I, O> ioResult) throws Exception {
            this.outputQueue.put(ioResult);
        }
    }
}

