/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.ldap.support;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.security.authc.ldap.support.LdapLoadBalancingSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class SessionFactorySettings {
    public static final String URLS_SETTING = "url";
    public static final String TIMEOUT_TCP_CONNECTION_SETTING = "timeout.tcp_connect";
    public static final String TIMEOUT_TCP_READ_SETTING = "timeout.tcp_read";
    public static final String TIMEOUT_LDAP_SETTING = "timeout.ldap_search";
    public static final String HOSTNAME_VERIFICATION_SETTING = "hostname_verification";
    public static final String FOLLOW_REFERRALS_SETTING = "follow_referrals";
    public static final Setting<Boolean> IGNORE_REFERRAL_ERRORS_SETTING = Setting.boolSetting((String)"ignore_referral_errors", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final TimeValue TIMEOUT_DEFAULT = TimeValue.timeValueSeconds((long)5L);

    private SessionFactorySettings() {
    }

    public static Set<Setting<?>> getSettings() {
        HashSet settings = new HashSet();
        settings.addAll(LdapLoadBalancingSettings.getSettings());
        settings.add(Setting.listSetting((String)URLS_SETTING, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_TCP_CONNECTION_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_TCP_READ_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.timeSetting((String)TIMEOUT_LDAP_SETTING, (TimeValue)TIMEOUT_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)HOSTNAME_VERIFICATION_SETTING, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)FOLLOW_REFERRALS_SETTING, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(IGNORE_REFERRAL_ERRORS_SETTING);
        settings.addAll(SSLConfigurationSettings.withPrefix("ssl.").getAllSettings());
        return settings;
    }
}

