/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.ml.datafeed.DatafeedConfigReader;
import org.elasticsearch.xpack.ml.datafeed.persistence.DatafeedConfigProvider;

public class TransportGetDatafeedsAction
extends TransportMasterNodeReadAction<GetDatafeedsAction.Request, GetDatafeedsAction.Response> {
    private final DatafeedConfigProvider datafeedConfigProvider;

    @Inject
    public TransportGetDatafeedsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, NamedXContentRegistry xContentRegistry) {
        super(settings, "cluster:monitor/xpack/ml/datafeeds/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetDatafeedsAction.Request::new);
        this.datafeedConfigProvider = new DatafeedConfigProvider(client, xContentRegistry);
    }

    protected String executor() {
        return "same";
    }

    protected GetDatafeedsAction.Response newResponse() {
        return new GetDatafeedsAction.Response();
    }

    protected void masterOperation(GetDatafeedsAction.Request request, ClusterState state, ActionListener<GetDatafeedsAction.Response> listener) {
        this.logger.debug("Get datafeed '{}'", (Object)request.getDatafeedId());
        DatafeedConfigReader datafeedConfigReader = new DatafeedConfigReader(this.datafeedConfigProvider);
        datafeedConfigReader.expandDatafeedConfigs(request.getDatafeedId(), request.allowNoDatafeeds(), state, (ActionListener<List<DatafeedConfig>>)ActionListener.wrap(datafeeds -> listener.onResponse((Object)new GetDatafeedsAction.Response(new QueryPage(datafeeds, (long)datafeeds.size(), DatafeedConfig.RESULTS_FIELD))), arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(GetDatafeedsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

