/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.srtp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpTransformer;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.srtp.SrtpCryptoContext;
import org.jitsi.srtp.SrtpErrorStatus;
import org.jitsi.utils.ByteArrayBuffer;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/srtp/SrtpDecryptTransformer;", "Lorg/jitsi/nlj/srtp/SrtpTransformer;", "contextFactory", "Lorg/jitsi/srtp/SrtpContextFactory;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jitsi/srtp/SrtpContextFactory;Lorg/jitsi/utils/logging2/Logger;)V", "alwaysProcess", "", "earlyDiscardedPacketsSinceLastSuccess", "", "getEarlyDiscardedPacketsSinceLastSuccess", "()I", "setEarlyDiscardedPacketsSinceLastSuccess", "(I)V", "doTransform", "Lorg/jitsi/srtp/SrtpErrorStatus;", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "context", "Lorg/jitsi/srtp/SrtpCryptoContext;", "transform", "jitsi-media-transform"})
public final class SrtpDecryptTransformer
extends SrtpTransformer {
    private int earlyDiscardedPacketsSinceLastSuccess;
    private final boolean alwaysProcess;

    public SrtpDecryptTransformer(@NotNull SrtpContextFactory contextFactory, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(contextFactory, "contextFactory");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(contextFactory, parentLogger);
        this.alwaysProcess = SrtpConfig.Companion.getMaxConsecutivePacketsDiscardedEarly() <= 0;
    }

    public final int getEarlyDiscardedPacketsSinceLastSuccess() {
        return this.earlyDiscardedPacketsSinceLastSuccess;
    }

    public final void setEarlyDiscardedPacketsSinceLastSuccess(int n) {
        this.earlyDiscardedPacketsSinceLastSuccess = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected SrtpErrorStatus transform(@NotNull PacketInfo packetInfo, @NotNull SrtpCryptoContext context) {
        SrtpErrorStatus srtpErrorStatus;
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!packetInfo.getShouldDiscard()) return this.doTransform(packetInfo, context);
        if (!this.alwaysProcess) {
            int n = this.earlyDiscardedPacketsSinceLastSuccess;
            this.earlyDiscardedPacketsSinceLastSuccess = n + 1;
            if (n <= SrtpConfig.Companion.getMaxConsecutivePacketsDiscardedEarly()) {
                srtpErrorStatus = SrtpErrorStatus.OK;
                return srtpErrorStatus;
            }
        }
        srtpErrorStatus = this.doTransform(packetInfo, context);
        return srtpErrorStatus;
    }

    private final SrtpErrorStatus doTransform(PacketInfo packetInfo, SrtpCryptoContext context) {
        SrtpErrorStatus srtpErrorStatus;
        SrtpErrorStatus it = srtpErrorStatus = context.reverseTransformPacket((ByteArrayBuffer)packetInfo.packetAs(), packetInfo.getShouldDiscard());
        boolean bl = false;
        packetInfo.resetPayloadVerification();
        if (it == SrtpErrorStatus.OK) {
            this.earlyDiscardedPacketsSinceLastSuccess = 0;
        }
        SrtpErrorStatus srtpErrorStatus2 = srtpErrorStatus;
        Intrinsics.checkNotNullExpressionValue((Object)srtpErrorStatus2, "context.reverseTransform\u20260\n            }\n        }");
        return srtpErrorStatus2;
    }
}

