/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.util.List;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.signaling.api.JvbApiConfig;
import org.jitsi.videobridge.stats.Statistics;
import org.jitsi.videobridge.stats.StatsTransport;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;

public class MucStatsTransport
implements StatsTransport {
    private static final Logger logger = new LoggerImpl(MucStatsTransport.class.getName());
    private final XmppConnection xmppConnection;

    public MucStatsTransport(XmppConnection xmppConnection) {
        this.xmppConnection = xmppConnection;
    }

    @Override
    public void publishStatistics(Statistics stats, long measurementInterval) {
        ColibriStatsExtension statsExt;
        logger.debug(() -> "Publishing statistics through MUC: " + String.valueOf(stats));
        if (XmppClientConnectionConfig.config.getStatsFilterEnabled()) {
            List<String> whitelist = XmppClientConnectionConfig.config.getStatsWhitelist();
            logger.debug(() -> "Statistics filter applied: " + String.valueOf(whitelist));
            statsExt = Statistics.toXmppExtensionElementFiltered(stats, whitelist);
        } else {
            statsExt = Statistics.toXmppExtensionElement(stats);
        }
        if (JvbApiConfig.enabled()) {
            // empty if block
        }
        this.xmppConnection.setPresenceExtension(statsExt);
    }
}

