/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.TimestampExtractor;

public class Consumed<K, V> {
    protected Serde<K> keySerde;
    protected Serde<V> valueSerde;
    protected TimestampExtractor timestampExtractor;
    protected Topology.AutoOffsetReset resetPolicy;

    private Consumed(Serde<K> keySerde, Serde<V> valueSerde, TimestampExtractor timestampExtractor, Topology.AutoOffsetReset resetPolicy) {
        this.keySerde = keySerde;
        this.valueSerde = valueSerde;
        this.timestampExtractor = timestampExtractor;
        this.resetPolicy = resetPolicy;
    }

    protected Consumed(Consumed<K, V> consumed) {
        this(consumed.keySerde, consumed.valueSerde, consumed.timestampExtractor, consumed.resetPolicy);
    }

    public static <K, V> Consumed<K, V> with(Serde<K> keySerde, Serde<V> valueSerde, TimestampExtractor timestampExtractor, Topology.AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(keySerde, valueSerde, timestampExtractor, resetPolicy);
    }

    public static <K, V> Consumed<K, V> with(Serde<K> keySerde, Serde<V> valueSerde) {
        return new Consumed<K, V>(keySerde, valueSerde, null, null);
    }

    public static <K, V> Consumed<K, V> with(TimestampExtractor timestampExtractor) {
        return new Consumed<K, V>(null, null, timestampExtractor, null);
    }

    public static <K, V> Consumed<K, V> with(Topology.AutoOffsetReset resetPolicy) {
        return new Consumed<K, V>(null, null, null, resetPolicy);
    }

    public Consumed<K, V> withKeySerde(Serde<K> keySerde) {
        this.keySerde = keySerde;
        return this;
    }

    public Consumed<K, V> withValueSerde(Serde<V> valueSerde) {
        this.valueSerde = valueSerde;
        return this;
    }

    public Consumed<K, V> withTimestampExtractor(TimestampExtractor timestampExtractor) {
        this.timestampExtractor = timestampExtractor;
        return this;
    }

    public Consumed<K, V> withOffsetResetPolicy(Topology.AutoOffsetReset resetPolicy) {
        this.resetPolicy = resetPolicy;
        return this;
    }
}

