/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.nodejs.run.profile.CategoryIndexFiles;
import com.jetbrains.nodejs.run.profile.V8IndexCatalogManager;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class V8IndexManager<T extends Enum> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.nodejs.run.profile.heap.calculation.V8IndexManager");
    protected final File mySnapshotFile;
    @NotNull
    private final T[] myCategoryValues;
    @NotNull
    private final Class<T> myCategoryClass;
    protected final ByteArrayWrapper myDigest;
    private File myRootDir;
    private boolean myInitialized;
    protected boolean myDoNotSerialize;
    protected final CategoryIndexFiles<T> myIndexFiles;

    public V8IndexManager(@NotNull File snapshotFile, @NotNull T[] categoryValues) throws IOException {
        if (snapshotFile == null) {
            V8IndexManager.$$$reportNull$$$0(0);
        }
        if (categoryValues == null) {
            V8IndexManager.$$$reportNull$$$0(1);
        }
        this.mySnapshotFile = snapshotFile;
        this.myCategoryValues = categoryValues;
        this.myCategoryClass = categoryValues[0].getClass();
        byte[] folderName = this.createDigest(this.mySnapshotFile);
        this.myDigest = new ByteArrayWrapper(folderName);
        if (folderName == null) {
            this.workInTmp();
            this.myIndexFiles = null;
            return;
        }
        this.myRootDir = V8IndexCatalogManager.getInstance().getOrCreate(folderName);
        if (this.myRootDir == null) {
            this.workInTmp();
            this.myIndexFiles = null;
            return;
        }
        if (!this.myRootDir.exists()) {
            this.myRootDir.mkdirs();
            this.myIndexFiles = new CategoryIndexFiles(this.myRootDir);
            return;
        }
        this.myIndexFiles = new CategoryIndexFiles(this.myRootDir);
        if (!this.tryInitFromDir()) {
            this.clearRoot();
        }
    }

    public void clearRoot() throws IOException {
        if (!FileUtil.delete((File)this.myRootDir)) {
            LOG.info("Can not clear index directory " + this.myRootDir.getPath() + " for heap indexes processing, going to use tmp directory...");
            this.workInTmp();
            return;
        }
        this.myRootDir.mkdirs();
    }

    public ByteArrayWrapper getDigest() {
        return this.myDigest;
    }

    private void workInTmp() throws IOException {
        this.myRootDir = FileUtil.createTempDirectory((String)"v8", null);
        this.myDoNotSerialize = true;
    }

    public boolean isInitialized() {
        return this.myInitialized;
    }

    protected File categoryFile(T category) {
        return new File(this.myRootDir, ((Enum)category).name());
    }

    private boolean tryInitFromDir() throws IOException {
        T descriptionCategory = this.getDescriptionCategory();
        File description = this.categoryFile(descriptionCategory);
        if (!description.exists()) {
            return false;
        }
        Map<T, List<Pair<String, byte[]>>> digests = V8IndexCatalogManager.readDigests(description, this.myCategoryClass);
        if (digests == null || !this.checkAllTypesArePresent(digests)) {
            return false;
        }
        HashMap<Enum, ArrayList<File>> map = new HashMap<Enum, ArrayList<File>>();
        for (Enum category : digests.keySet()) {
            if (((Enum)descriptionCategory).equals(category)) continue;
            List<Pair<String, byte[]>> shouldBeList = digests.get(category);
            if (shouldBeList == null) {
                return false;
            }
            for (Pair<String, byte[]> shouldBe : shouldBeList) {
                File file = new File(this.myRootDir, (String)shouldBe.getFirst());
                if (!file.exists()) {
                    return false;
                }
                if (!Arrays.equals((byte[])shouldBe.getSecond(), V8IndexCatalogManager.digestFile(file, new byte[0][]))) {
                    return false;
                }
                ArrayList<File> list = (ArrayList<File>)map.get(category);
                if (list == null) {
                    list = new ArrayList<File>();
                    map.put(category, list);
                }
                list.add(file);
            }
        }
        if (map.size() != digests.size()) {
            return false;
        }
        this.myIndexFiles.putAll(map);
        this.myInitialized = true;
        return true;
    }

    protected boolean checkAllTypesArePresent(Map<T, List<Pair<String, byte[]>>> digests) {
        return digests.size() == this.myCategoryValues.length - 1;
    }

    @NotNull
    public IndexFiles<T> getIndexFiles() {
        CategoryIndexFiles<T> categoryIndexFiles = this.myIndexFiles;
        if (categoryIndexFiles == null) {
            V8IndexManager.$$$reportNull$$$0(2);
        }
        return categoryIndexFiles;
    }

    protected abstract byte[] createDigest(@NotNull File var1) throws IOException;

    protected abstract T getDescriptionCategory();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categoryValues";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/V8IndexManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/V8IndexManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

