/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.phpdoc;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.phpdoc.GeneratePhpDocQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.PhpAddDocCommentFromBaseQuickFix;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMissingDocCommentInspection
extends PhpInspection {
    private static final LocalQuickFix[] GENERATE_FIX = new LocalQuickFix[]{GeneratePhpDocQuickFix.INSTANCE};
    private static final LocalQuickFix[] GENERATE_FIX_ON_THE_FLY = new LocalQuickFix[]{GeneratePhpDocQuickFix.ON_THE_FLY};
    private static final LocalQuickFix[] GENERATE_AND_COPY_FIXES = new LocalQuickFix[]{GeneratePhpDocQuickFix.INSTANCE, PhpAddDocCommentFromBaseQuickFix.INSTANCE};
    private static final LocalQuickFix[] GENERATE_ON_THE_FLY_AND_COPY_FIXES = new LocalQuickFix[]{GeneratePhpDocQuickFix.ON_THE_FLY, PhpAddDocCommentFromBaseQuickFix.INSTANCE};
    private static final String ERROR_ON_THE_FLY = PhpBundle.message("inspection.missing.doc.comment.problem", new Object[0]);
    private static final String ERROR_BATCH_CONSTANT = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "constant");
    private static final String ERROR_BATCH_FUNCTION = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "function");
    private static final String ERROR_BATCH_CLASS = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "class");
    private static final String ERROR_BATCH_METHOD = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "method");
    private static final String ERROR_BATCH_FIELD = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "field");
    private static final String ERROR_BATCH_CLASS_CONSTANT = PhpBundle.message("inspection.missing.doc.comment.problem.batch", "class constant");
    public boolean CHECK_CONSTANT = false;
    public boolean CHECK_FUNCTION = true;
    public boolean CHECK_CLASS = true;
    public boolean CHECK_METHOD = true;
    public boolean CHECK_FIELD = false;
    public boolean CHECK_CLASS_CONSTANT = false;
    public boolean SKIP_EMPTY_FUNCTION = true;
    public boolean SKIP_EMPTY_METHOD = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(0);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                if (PhpMissingDocCommentInspection.this.CHECK_CONSTANT) {
                    PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)constant, ERROR_BATCH_CONSTANT, holder, isOnTheFly);
                }
            }

            public void visitPhpFunction(Function function) {
                if (PhpMissingDocCommentInspection.this.CHECK_FUNCTION) {
                    PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)function, ERROR_BATCH_FUNCTION, holder, isOnTheFly);
                }
            }

            public void visitPhpClass(PhpClass clazz) {
                if (PhpMissingDocCommentInspection.this.CHECK_CLASS) {
                    PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)clazz, ERROR_BATCH_CLASS, holder, isOnTheFly);
                }
            }

            public void visitPhpMethod(Method method) {
                if (PhpMissingDocCommentInspection.this.CHECK_METHOD) {
                    PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)method, ERROR_BATCH_METHOD, holder, isOnTheFly);
                }
            }

            public void visitPhpField(Field field) {
                if (field.isConstant()) {
                    if (PhpMissingDocCommentInspection.this.CHECK_CLASS_CONSTANT) {
                        PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)field, ERROR_BATCH_CLASS_CONSTANT, holder, isOnTheFly);
                    }
                } else if (PhpMissingDocCommentInspection.this.CHECK_FIELD) {
                    PhpMissingDocCommentInspection.this.checkElement((PhpNamedElement)field, ERROR_BATCH_FIELD, holder, isOnTheFly);
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(1);
        }
        return phpElementVisitor;
    }

    private void checkElement(@NotNull PhpNamedElement namedElement, @NotNull String batchErrorMessage, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        ASTNode nameNode;
        if (namedElement == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(2);
        }
        if (batchErrorMessage == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(4);
        }
        if (namedElement instanceof Function && !this.isDocCommentNeededFor((Function)namedElement)) {
            return;
        }
        PhpDocComment comment = namedElement.getDocComment();
        if ((comment == null || PhpDocUtil.hasOnlyNoInspectionTag(comment)) && (nameNode = namedElement.getNameNode()) != null) {
            PhpDocComment docComment = PhpAddDocCommentFromBaseQuickFix.getBaseDocComment((PsiElement)namedElement);
            holder.registerProblem(nameNode.getPsi(), isOnTheFly ? ERROR_ON_THE_FLY : batchErrorMessage, PhpMissingDocCommentInspection.getFixes(docComment, isOnTheFly));
        }
    }

    @NotNull
    private static LocalQuickFix[] getFixes(@Nullable PhpDocComment docComment, boolean onTheFly) {
        if (onTheFly) {
            LocalQuickFix[] localQuickFixArray = docComment == null ? GENERATE_FIX_ON_THE_FLY : GENERATE_ON_THE_FLY_AND_COPY_FIXES;
            if (localQuickFixArray == null) {
                PhpMissingDocCommentInspection.$$$reportNull$$$0(5);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = docComment == null ? GENERATE_FIX : GENERATE_AND_COPY_FIXES;
        if (localQuickFixArray == null) {
            PhpMissingDocCommentInspection.$$$reportNull$$$0(6);
        }
        return localQuickFixArray;
    }

    private boolean isDocCommentNeededFor(Function function) {
        if (function instanceof Method ? !this.SKIP_EMPTY_METHOD : !this.SKIP_EMPTY_FUNCTION) {
            return true;
        }
        Parameter[] params = function.getParameters();
        if (params.length > 0) {
            return true;
        }
        if (function instanceof Method && ((Method)function).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            return false;
        }
        PhpType retType = function.getType().global(function.getProject());
        return !"void".equals(retType.toString()) && !retType.isEmpty();
    }

    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/phpdoc/PhpMissingDocCommentInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "batchErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/phpdoc/PhpMissingDocCommentInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myOptionsPanel;
        private JCheckBox myFunctionCheckBox;
        private JCheckBox myClassCheckBox;
        private JCheckBox myMethodCheckBox;
        private JCheckBox myFieldCheckBox;
        private JCheckBox myConstantCheckBox;
        private JCheckBox myClassConstantCheckBox;
        private JCheckBox mySkipEmptyFunctionBox;
        private JCheckBox mySkipEmptyMethodBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myConstantCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_CONSTANT);
            this.myConstantCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_CONSTANT = OptionsPanel.this.myConstantCheckBox.isSelected();
                }
            });
            this.myFunctionCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_FUNCTION);
            this.myFunctionCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_FUNCTION = OptionsPanel.this.myFunctionCheckBox.isSelected();
                }
            });
            this.myClassCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_CLASS);
            this.myClassCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_CLASS = OptionsPanel.this.myClassCheckBox.isSelected();
                }
            });
            this.myMethodCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_METHOD);
            this.myMethodCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_METHOD = OptionsPanel.this.myMethodCheckBox.isSelected();
                }
            });
            this.mySkipEmptyFunctionBox.setSelected(PhpMissingDocCommentInspection.this.SKIP_EMPTY_FUNCTION);
            this.mySkipEmptyFunctionBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.SKIP_EMPTY_FUNCTION = OptionsPanel.this.mySkipEmptyFunctionBox.isSelected();
                }
            });
            this.mySkipEmptyMethodBox.setSelected(PhpMissingDocCommentInspection.this.SKIP_EMPTY_METHOD);
            this.mySkipEmptyMethodBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.SKIP_EMPTY_METHOD = OptionsPanel.this.mySkipEmptyMethodBox.isSelected();
                }
            });
            this.myFieldCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_FIELD);
            this.myFieldCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_FIELD = OptionsPanel.this.myFieldCheckBox.isSelected();
                }
            });
            this.myClassConstantCheckBox.setSelected(PhpMissingDocCommentInspection.this.CHECK_CLASS_CONSTANT);
            this.myClassConstantCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpMissingDocCommentInspection.this.CHECK_CLASS_CONSTANT = OptionsPanel.this.myClassConstantCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JPanel jPanel;
            this.myOptionsPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            this.myConstantCheckBox = jCheckBox8 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox8, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.constant"));
            jPanel2.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myFieldCheckBox = jCheckBox7 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.field"));
            jPanel2.add((Component)jCheckBox7, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myClassConstantCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setSelected(false);
            this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.class.constant"));
            jPanel2.add((Component)jCheckBox6, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.myClassCheckBox = jCheckBox5 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox5, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.class"));
            jPanel2.add((Component)jCheckBox5, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new FlowLayout(0, 0, 5));
            jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myMethodCheckBox = jCheckBox4 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox4, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.method"));
            Component component = jPanel3.add(jCheckBox4);
            this.mySkipEmptyMethodBox = jCheckBox3 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.check.functions.without.params.and.return"));
            Component component2 = jPanel3.add(jCheckBox3);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new FlowLayout(0, 0, 5));
            jPanel2.add((Component)jPanel4, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
            this.myFunctionCheckBox = jCheckBox2 = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.options.panel.function"));
            Component component3 = jPanel4.add(jCheckBox2);
            this.mySkipEmptyFunctionBox = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/PhpBundle").getString("inspection.missing.doc.comment.check.functions.without.params.and.return"));
            Component component4 = jPanel4.add(jCheckBox);
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myOptionsPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

