/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import org.jetbrains.annotations.NotNull;

public class QualityToolMessage {
    private int lineNum = -1;
    public int column;
    public int length;
    private StringBuilder messageText;
    private final QualityToolMessageProcessor messageProcessor;
    private final TextRange myTextRange;
    @NotNull
    private final Severity severity;
    @NotNull
    private HighlightDisplayLevel displayLevel = HighlightDisplayLevel.ERROR;
    private IntentionAction[] quickFix;

    @NotNull
    public HighlightDisplayLevel getDisplayLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this.displayLevel;
        if (highlightDisplayLevel == null) {
            QualityToolMessage.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    void setDisplayLevel(@NotNull HighlightDisplayLevel displayLevel) {
        if (displayLevel == null) {
            QualityToolMessage.$$$reportNull$$$0(1);
        }
        this.displayLevel = displayLevel;
    }

    public QualityToolMessage(QualityToolMessageProcessor messageProcessor, int lineNum, Severity severity, String messageText, IntentionAction ... quickFix) {
        this.lineNum = lineNum;
        this.myTextRange = this.lineNumberToRange(lineNum - 1, messageProcessor);
        this.severity = severity != null ? severity : Severity.WARNING;
        this.messageText = new StringBuilder(messageText);
        this.messageProcessor = messageProcessor;
        this.quickFix = quickFix;
    }

    public QualityToolMessage(QualityToolMessageProcessor messageProcessor, TextRange textRange, Severity severity, String messageText, IntentionAction ... quickFix) {
        this.myTextRange = textRange;
        this.severity = severity != null ? severity : Severity.WARNING;
        this.messageText = new StringBuilder(messageText);
        this.messageProcessor = messageProcessor;
        this.quickFix = quickFix;
    }

    public void append(String messageText) {
        if (this.messageText.length() > 0) {
            this.messageText.append(' ');
        }
        this.messageText.append(messageText.trim());
    }

    private TextRange lineNumberToRange(int lineNum, QualityToolMessageProcessor messageProcessor) {
        Document doc = PsiDocumentManager.getInstance((Project)messageProcessor.getFile().getProject()).getDocument(messageProcessor.getFile());
        if (doc == null || lineNum < 0 || lineNum >= doc.getLineCount()) {
            return TextRange.EMPTY_RANGE;
        }
        int startOffset = doc.getLineStartOffset(lineNum) + this.column;
        int endOffset = this.length > 0 ? startOffset + this.length : doc.getLineEndOffset(lineNum);
        return TextRange.create((int)startOffset, (int)endOffset);
    }

    private int rangeToLineNumber(TextRange range) {
        Document doc = PsiDocumentManager.getInstance((Project)this.messageProcessor.getFile().getProject()).getDocument(this.messageProcessor.getFile());
        int offset = range.getStartOffset();
        return doc != null && offset < doc.getTextLength() ? doc.getLineNumber(offset) : 0;
    }

    public int getLineNum() {
        return this.lineNum != -1 ? this.lineNum : this.rangeToLineNumber(this.myTextRange);
    }

    public TextRange getTextRange() {
        return this.myTextRange;
    }

    public String getMessageText() {
        String prefix = this.messageProcessor.getMessagePrefix();
        return prefix == null ? this.messageText.toString() : prefix + ": " + this.messageText;
    }

    public boolean isInternalError() {
        return Severity.INTERNAL_ERROR.equals((Object)this.severity);
    }

    public void substitute(String sample, String replacement) {
        String messageString = this.messageText.toString();
        if (messageString.contains(sample)) {
            this.messageText = new StringBuilder(messageString.replace(sample, replacement));
        }
    }

    @NotNull
    public Severity getSeverity() {
        Severity severity = this.severity;
        if (severity == null) {
            QualityToolMessage.$$$reportNull$$$0(2);
        }
        return severity;
    }

    @NotNull
    public IntentionAction[] getQuickFix() {
        IntentionAction[] intentionActionArray = this.quickFix != null ? this.quickFix : IntentionAction.EMPTY_ARRAY;
        if (intentionActionArray == null) {
            QualityToolMessage.$$$reportNull$$$0(3);
        }
        return intentionActionArray;
    }

    public void setQuickFix(@NotNull IntentionAction[] quickFix) {
        if (quickFix == null) {
            QualityToolMessage.$$$reportNull$$$0(4);
        }
        this.quickFix = quickFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolMessage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayLevel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayLevel";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setQuickFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Severity {
        INTERNAL_ERROR,
        ERROR,
        WARNING;

    }
}

