/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.hash.HashSet;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolExecutionException;
import com.jetbrains.php.tools.quality.QualityToolMessage;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import java.io.IOException;
import java.io.StringReader;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class QualityToolXmlMessageProcessor
extends QualityToolMessageProcessor {
    private StringBuilder messageBuf;
    private int myPrevLine = -1;
    private final Set<String> lineMessages = new HashSet();
    private StringBuilder errorBuf;
    private boolean myHasMessages = false;
    protected SAXParser mySAXParser;
    private static final Logger LOG = Logger.getInstance(QualityToolXmlMessageProcessor.class);

    protected QualityToolXmlMessageProcessor(QualityToolAnnotatorInfo info, int maxMessages) {
        super(info, maxMessages);
        try {
            this.mySAXParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException e) {
            LOG.error(e.getMessage());
        }
        catch (SAXException e) {
            LOG.error(e.getMessage());
        }
    }

    @Override
    public void parseLine(String line) {
        boolean isErrorMessageEnd;
        boolean isErrorMessageStart;
        if (LOG.isDebugEnabled()) {
            LOG.debug("'" + line + "'");
        }
        if (QualityToolXmlMessageProcessor.canBeMessageStart(line) && this.messageBuf == null) {
            this.messageBuf = new StringBuilder();
        }
        if (this.messageBuf == null) {
            if (!this.myHasMessages && StringUtil.isNotEmpty((String)line)) {
                if (this.errorBuf == null) {
                    this.errorBuf = new StringBuilder();
                }
                this.errorBuf.append(line);
            }
            return;
        }
        String message = this.messageBuf.append(line).toString().trim();
        boolean bl = isErrorMessageStart = this.getMessageStart(message) > -1;
        if (QualityToolXmlMessageProcessor.canBeMessageEnd(message) && !isErrorMessageStart) {
            this.messageBuf = null;
            return;
        }
        boolean bl2 = isErrorMessageEnd = this.getMessageEnd(message) > -1;
        if (isErrorMessageEnd) {
            InputSource source = new InputSource(new StringReader(message));
            this.myHasMessages = true;
            this.messageBuf = null;
            try {
                this.processMessage(source);
            }
            catch (SAXException e) {
                LOG.error(e.getMessage() + message);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        }
    }

    protected void processMessage(InputSource source) throws SAXException, IOException {
        XMLMessageHandler messageHandler = this.getXmlMessageHandler();
        this.mySAXParser.parse(source, (DefaultHandler)messageHandler);
        if (messageHandler.isStatusValid()) {
            String messageText;
            QualityToolMessage qualityToolMessage = new QualityToolMessage((QualityToolMessageProcessor)this, messageHandler.getLineNumber(), messageHandler.getSeverity(), messageHandler.getMessageText(), new IntentionAction[0]);
            int currLine = qualityToolMessage.getLineNum();
            if (currLine != this.myPrevLine) {
                this.lineMessages.clear();
                this.myPrevLine = currLine;
            }
            if (!this.lineMessages.contains(messageText = qualityToolMessage.getMessageText())) {
                this.lineMessages.add(messageText);
                this.addMessage(qualityToolMessage);
            }
        }
    }

    private static boolean canBeMessageStart(String message) {
        return StringUtil.startsWith((CharSequence)message.trim(), (CharSequence)"<");
    }

    private static boolean canBeMessageEnd(String message) {
        return StringUtil.endsWith((CharSequence)message, (CharSequence)">");
    }

    @Override
    public void done() throws QualityToolExecutionException {
        if (!this.myHasMessages && this.errorBuf != null) {
            throw new QualityToolExecutionException(this.errorBuf.toString());
        }
    }

    protected abstract XMLMessageHandler getXmlMessageHandler();

    public abstract int getMessageStart(@NotNull String var1);

    public abstract int getMessageEnd(@NotNull String var1);

    protected static abstract class XMLMessageHandler
    extends DefaultHandler {
        protected int myLineNumber = -1;
        protected QualityToolMessage.Severity mySeverity;
        protected final StringBuilder myMessageBuf = new StringBuilder();

        protected XMLMessageHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.parseTag(qName, attributes);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myMessageBuf.append(ch, start, length);
        }

        protected abstract void parseTag(@NotNull String var1, @NotNull Attributes var2);

        public int getLineNumber() {
            return this.myLineNumber;
        }

        public QualityToolMessage.Severity getSeverity() {
            return this.mySeverity;
        }

        public String getMessageText() {
            String messageText = this.myMessageBuf.toString().trim();
            if (messageText.indexOf(10) >= 0) {
                messageText = messageText.replace('\n', ' ');
            }
            return messageText;
        }

        public boolean isStatusValid() {
            return this.myLineNumber > -1 && this.myMessageBuf.length() > 0;
        }

        protected static int parseLineNumber(@Nullable String lineNumStr) {
            if (lineNumStr != null) {
                try {
                    return Integer.parseInt(lineNumStr);
                }
                catch (NumberFormatException nfe) {
                    LOG.error("Invalid line number: " + lineNumStr);
                }
            } else {
                LOG.error("Missing line number");
            }
            return -1;
        }
    }
}

