/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.io.PathKt;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ExceptionCatchMode;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.VmBase;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.v8.BreakEventHandlerKt;
import org.jetbrains.v8.EventMap;
import org.jetbrains.v8.V8BreakpointManager;
import org.jetbrains.v8.V8CommandProcessor;
import org.jetbrains.v8.V8EvaluateContext;
import org.jetbrains.v8.V8ScriptManager;
import org.jetbrains.v8.V8SuspendContextManager;
import org.jetbrains.v8.V8VersionFeatures;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.V8VmKt;
import org.jetbrains.v8.protocol.FrameInfo;
import org.jetbrains.v8.protocol.GetFramesResult;
import org.jetbrains.v8.protocol.GetScriptsResult;
import org.jetbrains.v8.protocol.IncomingMessage;
import org.jetbrains.v8.protocol.OriginalProtocolKt;
import org.jetbrains.v8.protocol.ProtocolKt;
import org.jetbrains.v8.protocol.ScriptDescriptor;
import org.jetbrains.v8.protocol.ScriptHandle;
import org.jetbrains.v8.protocol.ScriptsMessageKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.value.V8ValueManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010?\u001a\u00020>J\n\u0010@\u001a\u0004\u0018\u00010AH\u0004J\u000e\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH\u0002J\u0012\u0010E\u001a\u0006\u0012\u0002\b\u00030C2\u0006\u0010F\u001a\u00020GJ\u0018\u0010H\u001a\u00020D2\u000e\u0010I\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00000)H\u0014J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020LH$R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\n\"\u0004\b \u0010\fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010&\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\n\"\u0004\b'\u0010\fR\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u00020\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u001b\"\u0004\b-\u0010\u001dR\u001a\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u0010\u0010\u001a\u0004\b1\u00102R\u0017\u00103\u001a\u000204\u00a2\u0006\u000e\n\u0000\u0012\u0004\b5\u0010\u0010\u001a\u0004\b6\u00107R\u000e\u00108\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010:\u001a\u0004\u0018\u00010\u00192\b\u00109\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010\u001b\"\u0004\b<\u0010\u001d\u00a8\u0006M"}, d2={"Lorg/jetbrains/v8/V8Vm;", "Lorg/jetbrains/debugger/VmBase;", "Lorg/jetbrains/debugger/Vm;", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "(Lorg/jetbrains/debugger/DebugEventListener;)V", "<set-?>", "", "bootstrapped", "getBootstrapped", "()Z", "setBootstrapped$intellij_javascript_v8_backend", "(Z)V", "breakpointManager", "Lorg/jetbrains/v8/V8BreakpointManager;", "breakpointManager$annotations", "()V", "getBreakpointManager", "()Lorg/jetbrains/v8/V8BreakpointManager;", "commandProcessor", "Lorg/jetbrains/v8/V8CommandProcessor;", "commandProcessor$annotations", "getCommandProcessor", "()Lorg/jetbrains/v8/V8CommandProcessor;", "embeddingHost", "", "getEmbeddingHost", "()Ljava/lang/String;", "setEmbeddingHost", "(Ljava/lang/String;)V", "hasJbDebuggerSupport", "getHasJbDebuggerSupport", "setHasJbDebuggerSupport", "initialBreakEvent", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/v8/protocol/IncomingMessage;", "getInitialBreakEvent$intellij_javascript_v8_backend", "()Ljava/util/concurrent/atomic/AtomicReference;", "isAbleToReportSourceMapUrl", "setAbleToReportSourceMapUrl", "jbDebuggerSupportInstalled", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "presentableName", "getPresentableName", "setPresentableName", "scriptManager", "Lorg/jetbrains/v8/V8ScriptManager;", "scriptManager$annotations", "getScriptManager", "()Lorg/jetbrains/v8/V8ScriptManager;", "suspendContextManager", "Lorg/jetbrains/v8/V8SuspendContextManager;", "suspendContextManager$annotations", "getSuspendContextManager", "()Lorg/jetbrains/v8/V8SuspendContextManager;", "valueModificationSupported", "value", "vmVersion", "getVmVersion", "setVmVersion", "checkValueModifier", "Lorg/jetbrains/debugger/ValueModifier;", "valueModifier", "computeEvaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "loadScriptsFallback", "Lorg/jetbrains/concurrency/Promise;", "", "setBreakOnException", "catchMode", "Lorg/jetbrains/debugger/ExceptionCatchMode;", "startCommunication", "vmResult", "write", "content", "Lio/netty/buffer/ByteBuf;", "intellij.javascript.v8.backend"})
public abstract class V8Vm
extends VmBase
implements Vm {
    @NotNull
    private String presentableName;
    @NotNull
    private final V8ScriptManager scriptManager;
    @NotNull
    private final V8CommandProcessor commandProcessor;
    @NotNull
    private final V8SuspendContextManager suspendContextManager;
    @NotNull
    private final V8BreakpointManager breakpointManager;
    @Nullable
    private volatile String vmVersion;
    @Nullable
    private volatile String embeddingHost;
    private boolean valueModificationSupported;
    private volatile boolean hasJbDebuggerSupport;
    private volatile boolean bootstrapped;
    private volatile boolean isAbleToReportSourceMapUrl;
    private final AsyncPromise<Object> jbDebuggerSupportInstalled;
    @NotNull
    private final AtomicReference<IncomingMessage> initialBreakEvent;

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    public void setPresentableName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.presentableName = string;
    }

    public static /* synthetic */ void scriptManager$annotations() {
    }

    @NotNull
    public V8ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public static /* synthetic */ void commandProcessor$annotations() {
    }

    @NotNull
    public final V8CommandProcessor getCommandProcessor() {
        return this.commandProcessor;
    }

    public static /* synthetic */ void suspendContextManager$annotations() {
    }

    @NotNull
    public final V8SuspendContextManager getSuspendContextManager() {
        return this.suspendContextManager;
    }

    public static /* synthetic */ void breakpointManager$annotations() {
    }

    @NotNull
    public final V8BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Nullable
    public final String getVmVersion() {
        return this.vmVersion;
    }

    public final void setVmVersion(@Nullable String value) {
        this.vmVersion = value;
        this.valueModificationSupported = StringUtil.compareVersionNumbers((String)this.vmVersion, (String)"3.16") >= 0;
        this.breakpointManager.setRegExpBreakpointSupported(V8VersionFeatures.isRegExpBreakpointSupported(this.vmVersion));
    }

    @Nullable
    public final String getEmbeddingHost() {
        return this.embeddingHost;
    }

    public final void setEmbeddingHost(@Nullable String string) {
        this.embeddingHost = string;
    }

    public final boolean getHasJbDebuggerSupport() {
        return this.hasJbDebuggerSupport;
    }

    private final void setHasJbDebuggerSupport(boolean bl) {
        this.hasJbDebuggerSupport = bl;
    }

    public final boolean getBootstrapped() {
        return this.bootstrapped;
    }

    public final void setBootstrapped$intellij_javascript_v8_backend(boolean bl) {
        this.bootstrapped = bl;
    }

    public final boolean isAbleToReportSourceMapUrl() {
        return this.isAbleToReportSourceMapUrl;
    }

    private final void setAbleToReportSourceMapUrl(boolean bl) {
        this.isAbleToReportSourceMapUrl = bl;
    }

    protected abstract boolean write(@NotNull ByteBuf var1);

    @NotNull
    public final Promise<?> setBreakOnException(@NotNull ExceptionCatchMode catchMode) {
        Intrinsics.checkParameterIsNotNull((Object)catchMode, (String)"catchMode");
        return this.breakpointManager.setBreakOnException(catchMode);
    }

    @NotNull
    public final AtomicReference<IncomingMessage> getInitialBreakEvent$intellij_javascript_v8_backend() {
        return this.initialBreakEvent;
    }

    protected void startCommunication(@NotNull AsyncPromise<? super V8Vm> vmResult) {
        Intrinsics.checkParameterIsNotNull(vmResult, (String)"vmResult");
        if (Intrinsics.areEqual((Object)this.embeddingHost, (Object)"Electron") ^ true && Registry.is((String)"nodejs.debugger.use.jb.support", (boolean)true)) {
            String debuggerSupport;
            URL uRL = V8Vm.class.getResource("");
            Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"V8Vm::class.java.getResource(\"\")");
            if (Intrinsics.areEqual((Object)"jar", (Object)uRL.getProtocol())) {
                String string = V8VmKt.access$getSCRIPT_DEBUGGER_SUPPORT_SOURCE$p();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SCRIPT_DEBUGGER_SUPPORT_SOURCE");
                debuggerSupport = string;
            } else {
                Path path = Paths.get(PathManager.getPreInstalledPluginsPath(), "JavaScriptDebugger/sdk/v8/backend/src/debuggerSupport.js");
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(PathManager.ge\u2026/src/debuggerSupport.js\")");
                debuggerSupport = PathKt.readText((Path)path);
                debuggerSupport = "try {" + debuggerSupport + "} catch (e) {throw new Error(e.stack)}";
            }
            EvaluateContext evaluateContext2 = this.getEvaluateContext();
            if (evaluateContext2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)EvaluateContext.DefaultImpls.evaluate$default((EvaluateContext)evaluateContext2, (String)debuggerSupport, null, (boolean)false, null, (int)14, null).onSuccess((Consumer)new Consumer<EvaluateResult>(this, vmResult){
                final /* synthetic */ V8Vm this$0;
                final /* synthetic */ AsyncPromise $vmResult;

                public final void accept(EvaluateResult it) {
                    AsyncPromise $receiver$iv = V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0);
                    try {
                        Object object;
                        if (it.getWasThrown()) {
                            StringBuilder stringBuilder = new StringBuilder().append("Cannot install our debugger support: ");
                            String string = it.getValue().getValueString();
                            if (string == null) {
                                string = it;
                            }
                            String message = stringBuilder.append((Object)string).toString();
                            CommandProcessorKt.getLOG().info(message);
                            this.$vmResult.setResult((Object)((Object)this.this$0));
                            object = V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0).setError(message);
                        } else {
                            Object object2;
                            V8Vm.access$setHasJbDebuggerSupport$p(this.this$0, true);
                            if (it.getValue().getType() == ValueType.STRING && (object2 = it.getValue().getValueString()) != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])new char[]{'|'}, (boolean)false, (int)0, (int)6, null)) != null) {
                                Object object3;
                                Object it2 = object3 = object2;
                                V8Vm.access$setAbleToReportSourceMapUrl$p(this.this$0, Intrinsics.areEqual((Object)((String)CollectionsKt.getOrNull((List)it2, (int)0)), (Object)"true"));
                                String string = V8VmKt.computeName((List<String>)it2, 1);
                                if (string != null) {
                                    String string2;
                                    String it3 = string2 = string;
                                    this.this$0.setPresentableName(it3);
                                }
                            }
                            this.$vmResult.setResult((Object)((Object)this.this$0));
                            V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0).setResult(null);
                            object = Unit.INSTANCE;
                        }
                        Unit unit = object;
                    }
                    catch (Throwable e$iv) {
                        $receiver$iv.setError(e$iv);
                        Object var10_8 = null;
                    }
                }
                {
                    this.this$0 = v8Vm;
                    this.$vmResult = asyncPromise;
                }
            }).onError((Consumer)new Consumer<Throwable>(this, vmResult){
                final /* synthetic */ V8Vm this$0;
                final /* synthetic */ AsyncPromise $vmResult;

                public final void accept(Throwable it) {
                    CommandProcessorKt.getLOG().info("Cannot install our debugger support", it);
                    this.$vmResult.setResult((Object)((Object)this.this$0));
                    AsyncPromise asyncPromise = V8Vm.access$getJbDebuggerSupportInstalled$p(this.this$0);
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    asyncPromise.setError(throwable);
                }
                {
                    this.this$0 = v8Vm;
                    this.$vmResult = asyncPromise;
                }
            }), (String)"evaluateContext!!.evalua\u2026ed.setError(it)\n        }");
        } else {
            vmResult.setResult((Object)this);
            this.jbDebuggerSupportInstalled.setResult(null);
        }
        this.jbDebuggerSupportInstalled.onProcessed((Consumer)new Consumer<Object>(this){
            final /* synthetic */ V8Vm this$0;

            public final void accept(@Nullable Object it) {
                Promise promise2;
                if (this.this$0.getHasJbDebuggerSupport()) {
                    AsyncPromise result = new AsyncPromise();
                    this.this$0.getCommandProcessor().send((Request)ProtocolKt.GetScripts$default(null, 1, null)).onSuccess((Consumer)new Consumer<GetScriptsResult>(this, result){
                        final /* synthetic */ startCommunication.3 this$0;
                        final /* synthetic */ AsyncPromise $result;

                        public final void accept(GetScriptsResult it) {
                            AsyncPromise $receiver$iv = this.$result;
                            try {
                                Iterable $receiver$iv2 = it.scripts();
                                for (T element$iv : $receiver$iv2) {
                                    ScriptDescriptor it2 = (ScriptDescriptor)element$iv;
                                    this.this$0.this$0.getScriptManager().addScript(it2);
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable e$iv) {
                                $receiver$iv.setError(e$iv);
                                Object var10_8 = null;
                            }
                            this.$result.setResult(null);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = asyncPromise;
                        }
                    }).onError((Consumer)new Consumer<Throwable>(this, result){
                        final /* synthetic */ startCommunication.3 this$0;
                        final /* synthetic */ AsyncPromise $result;

                        public final void accept(Throwable it) {
                            V8Vm.access$setHasJbDebuggerSupport$p(this.this$0.this$0, false);
                            V8Vm.access$loadScriptsFallback(this.this$0.this$0).processed((Promise)this.$result);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$result = asyncPromise;
                        }
                    });
                    promise2 = (Promise)result;
                } else {
                    promise2 = V8Vm.access$loadScriptsFallback(this.this$0);
                }
                Promise promise3 = promise2;
                promise3.onSuccess((Consumer)new Consumer<Unit>(this){
                    final /* synthetic */ startCommunication.3 this$0;

                    public final void accept(@Nullable Unit it) {
                        IncomingMessage breakEvent = this.this$0.this$0.getInitialBreakEvent$intellij_javascript_v8_backend().getAndSet(null);
                        this.this$0.this$0.setBootstrapped$intellij_javascript_v8_backend(true);
                        if (breakEvent != null) {
                            BreakEventHandlerKt.processBreak(breakEvent, this.this$0.this$0);
                        } else if (V8VersionFeatures.isRunningAccurate(this.this$0.this$0.getVmVersion()) && !this.this$0.this$0.getCommandProcessor().lastSuccessResponse().running() && this.this$0.this$0.getSuspendContextManager().getContext() == null) {
                            if (this.this$0.this$0.getHasJbDebuggerSupport()) {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.this$0.getCommandProcessor().send((Request)ProtocolKt.GetFrames(0, 1)).onSuccess((Consumer)new Consumer<GetFramesResult>(this){
                                    final /* synthetic */ startCommunication.1 this$0;

                                    public final void accept(GetFramesResult it) {
                                        if (this.this$0.this$0.this$0.getSuspendContextManager().getContext() == null) {
                                            V8SuspendContextManager v8SuspendContextManager = this.this$0.this$0.this$0.getSuspendContextManager();
                                            GetFramesResult getFramesResult = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)getFramesResult, (String)"it");
                                            v8SuspendContextManager.createAndSetContextIfNotExists(getFramesResult, false);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)"commandProcessor.send(Ge\u2026      }\n                }");
                            } else {
                                Intrinsics.checkExpressionValueIsNotNull((Object)this.this$0.this$0.getCommandProcessor().send((Request)OriginalProtocolKt.FrameMessage()).onSuccess((Consumer)new Consumer<FrameInfo>(this){
                                    final /* synthetic */ startCommunication.1 this$0;

                                    public final void accept(FrameInfo it) {
                                        if (this.this$0.this$0.this$0.getSuspendContextManager().getContext() == null) {
                                            V8SuspendContextManager v8SuspendContextManager = this.this$0.this$0.this$0.getSuspendContextManager();
                                            FrameInfo frameInfo = it;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)frameInfo, (String)"it");
                                            v8SuspendContextManager.createAndSetContextIfNotExists(frameInfo, false);
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                }), (String)"commandProcessor.send(Fr\u2026      }\n                }");
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = v8Vm;
            }
        });
    }

    private final Promise<Unit> loadScriptsFallback() {
        Promise promise2 = this.commandProcessor.send((Request)ScriptsMessageKt.ScriptsMessage$default(false, 0, 0, null, null, 31, null)).then(new Function<T, SUB_RESULT>(this){
            final /* synthetic */ V8Vm this$0;

            public final void fun(List<? extends ScriptHandle> it) {
                List<SomeHandle> refs = ((IncomingMessage)this.this$0.getCommandProcessor().lastSuccessResponse().getBase()).refs();
                for (ScriptHandle scriptHandle : it) {
                    this.this$0.getScriptManager().addScript(scriptHandle, refs);
                }
            }
            {
                this.this$0 = v8Vm;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"commandProcessor.send(Sc\u2026, refs)\n        }\n      }");
        return promise2;
    }

    @Nullable
    public final ValueModifier checkValueModifier(@NotNull ValueModifier valueModifier) {
        Intrinsics.checkParameterIsNotNull((Object)valueModifier, (String)"valueModifier");
        return this.valueModificationSupported ? valueModifier : null;
    }

    @Nullable
    protected final EvaluateContext computeEvaluateContext() {
        return (EvaluateContext)new V8EvaluateContext(this, new V8ValueManager(this)){
            private final int frameIndex = -1;
            final /* synthetic */ V8Vm this$0;

            protected int getFrameIndex() {
                return this.frameIndex;
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
                this.frameIndex = -1;
            }
        };
    }

    public V8Vm(@NotNull DebugEventListener debugEventListener) {
        Intrinsics.checkParameterIsNotNull((Object)debugEventListener, (String)"debugEventListener");
        super(debugEventListener);
        this.presentableName = super.getPresentableName();
        this.scriptManager = new V8ScriptManager(this);
        this.commandProcessor = new V8CommandProcessor((Function1<? super ByteBuf, Boolean>)((Function1)new Function1<ByteBuf, Boolean>(this){
            final /* synthetic */ V8Vm this$0;

            public final boolean invoke(@NotNull ByteBuf it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return this.this$0.write(it);
            }
            {
                this.this$0 = v8Vm;
                super(1);
            }
        }), new EventMap(this));
        this.suspendContextManager = new V8SuspendContextManager(this);
        this.breakpointManager = new V8BreakpointManager(this);
        this.jbDebuggerSupportInstalled = new AsyncPromise();
        this.initialBreakEvent = new AtomicReference();
    }

    @NotNull
    public static final /* synthetic */ AsyncPromise access$getJbDebuggerSupportInstalled$p(V8Vm $this) {
        return $this.jbDebuggerSupportInstalled;
    }

    public static final /* synthetic */ boolean access$getHasJbDebuggerSupport$p(V8Vm $this) {
        return $this.hasJbDebuggerSupport;
    }

    public static final /* synthetic */ void access$setHasJbDebuggerSupport$p(V8Vm $this, boolean bl) {
        $this.hasJbDebuggerSupport = bl;
    }

    public static final /* synthetic */ boolean access$isAbleToReportSourceMapUrl$p(V8Vm $this) {
        return $this.isAbleToReportSourceMapUrl;
    }

    public static final /* synthetic */ void access$setAbleToReportSourceMapUrl$p(V8Vm $this, boolean bl) {
        $this.isAbleToReportSourceMapUrl = bl;
    }

    @NotNull
    public static final /* synthetic */ Promise access$loadScriptsFallback(V8Vm $this) {
        return $this.loadScriptsFallback();
    }
}

