/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.run.config;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ws.http.request.HttpRequestPsiFile;
import com.intellij.ws.http.request.HttpRequestPsiUtils;
import com.intellij.ws.http.request.psi.HttpRequestBlock;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class HttpRequestComboBox
extends ComboBox<HttpRequestItem> {
    public void reset(@NotNull HttpRequestPsiFile file, int selected) {
        HttpRequestItem selectedItem;
        if (file == null) {
            HttpRequestComboBox.$$$reportNull$$$0(0);
        }
        HttpRequestBlock[] blocks = HttpRequestPsiUtils.getRequestBlocks((PsiFile)file);
        ArrayList<HttpOrderRequestItem> items = new ArrayList<HttpOrderRequestItem>();
        for (int i = 0; i < blocks.length; ++i) {
            items.add(new HttpOrderRequestItem(i + 1, true));
        }
        boolean isValid = selected <= blocks.length;
        HttpRequestItem httpRequestItem = selectedItem = isValid ? (HttpRequestItem)items.get(selected - 1) : new HttpOrderRequestItem(selected, false);
        if (!isValid) {
            items.add((HttpOrderRequestItem)selectedItem);
        }
        this.setModel((ComboBoxModel)new CollectionComboBoxModel(items));
        this.getModel().setSelectedItem(selectedItem);
        this.setRenderer((ListCellRenderer)new ColoredListCellRenderer<HttpRequestItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends HttpRequestItem> list, HttpRequestItem value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value != null) {
                    this.append(value.getPresentableName(), value.isValid() ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ws/http/request/run/config/HttpRequestComboBox$1", "customizeCellRenderer"));
            }
        });
    }

    public int getSelectedRequestIndex() {
        HttpRequestItem item = (HttpRequestItem)this.getSelectedItem();
        return item instanceof HttpOrderRequestItem ? ((HttpOrderRequestItem)item).getIndex() : 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ws/http/request/run/config/HttpRequestComboBox", "reset"));
    }

    public static class HttpOrderRequestItem
    implements HttpRequestItem {
        private static final String NAME_PREFIX = "#";
        private final int myIndex;
        private final boolean myIsValid;

        public HttpOrderRequestItem(int index, boolean isValid) {
            this.myIndex = index;
            this.myIsValid = isValid;
        }

        public int getIndex() {
            return this.myIndex;
        }

        @Override
        public String getPresentableName() {
            return NAME_PREFIX + this.myIndex;
        }

        @Override
        public boolean isValid() {
            return this.myIsValid;
        }
    }

    public static interface HttpRequestItem {
        public String getPresentableName();

        public boolean isValid();
    }
}

