/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.Url;
import com.intellij.util.containers.ConcurrentMultiMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J<\u0010\u0012\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0015J(\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u00172\u0006\u0010\u0018\u001a\u00020\u00052\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00170\u0015J6\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "", "()V", "fileToUrlMap", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMapping;", "urlToFileMap", "", "Lcom/intellij/util/Url;", "checkMappingIsValid", "", "mapping", "findByFullName", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "findFile", "url", "finder", "Lkotlin/Function0;", "findUrls", "", "file", "saveMapping", "", "intellij.javascript.debugger"})
public final class JSFileUrlMappings {
    private final Map<Url, FileUrlMapping> urlToFileMap;
    private final MultiMap<VirtualFile, FileUrlMapping> fileToUrlMap;

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, boolean findByFullName, @Nullable String sourceContent, @Nullable Script script, @NotNull Function0<? extends VirtualFile> finder) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(finder, (String)"finder");
        FileUrlMapping cachedValue = this.urlToFileMap.get(url);
        if (cachedValue != null && this.checkMappingIsValid(cachedValue, findByFullName, sourceContent, script)) {
            return cachedValue.getFile();
        }
        VirtualFile file = (VirtualFile)finder.invoke();
        this.saveMapping(url, file, findByFullName, sourceContent, script);
        return file;
    }

    private final void saveMapping(Url url, VirtualFile file, boolean findByFullName, String sourceContent, Script script) {
        FileUrlMapping mapping = new FileUrlMapping(url, file, findByFullName, sourceContent, script);
        Map<Url, FileUrlMapping> map = this.urlToFileMap;
        FileUrlMapping fileUrlMapping = mapping;
        map.put(url, fileUrlMapping);
        if (file != null) {
            this.fileToUrlMap.putValue((Object)file, (Object)mapping);
        }
    }

    @NotNull
    public final List<Url> findUrls(@NotNull VirtualFile file, @NotNull Function0<? extends List<? extends Url>> finder) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(finder, (String)"finder");
        if (this.fileToUrlMap.containsKey((Object)file)) {
            FileUrlMapping it;
            Iterable $receiver$iv$iv;
            Iterable $receiver$iv;
            ArrayList cachedMappings = new ArrayList(this.fileToUrlMap.get((Object)file));
            Iterable iterable = $receiver$iv = (Iterable)cachedMappings;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                FileUrlMapping fileUrlMapping = it = (FileUrlMapping)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)fileUrlMapping, (String)"it");
                if (!JSFileUrlMappings.checkMappingIsValid$default(this, fileUrlMapping, true, null, null, 12, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (FileUrlMapping)item$iv$iv;
                Collection collection = destination$iv$iv;
                Url url = it.getUrl();
                collection.add(url);
            }
            List result2 = (List)destination$iv$iv;
            if (!result2.isEmpty()) {
                return result2;
            }
        }
        List urls = (List)finder.invoke();
        Iterable $receiver$iv = urls;
        for (Object element$iv : $receiver$iv) {
            Url it = (Url)element$iv;
            this.saveMapping(it, file, true, null, null);
        }
        return urls;
    }

    private final boolean checkMappingIsValid(FileUrlMapping mapping, boolean findByFullName, String sourceContent, Script script) {
        boolean isValid;
        boolean bl;
        boolean isNewMappingMoreAccurate;
        boolean bl2 = sourceContent != null && !mapping.getResolvedWithContent() ? true : (sourceContent == null && mapping.getResolvedWithContent() ? false : (findByFullName && !mapping.getResolvedWithFullName() ? true : (!findByFullName && mapping.getResolvedWithFullName() ? false : (isNewMappingMoreAccurate = script != null && !mapping.getResolvedWithScript()))));
        if (isNewMappingMoreAccurate) {
            bl = false;
        } else if (mapping.getFile() != null) {
            bl = mapping.getFile().getModificationStamp() == mapping.getFileOrFsModificationStamp() && !FileDocumentManager.getInstance().isFileModified(mapping.getFile());
        } else {
            VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
            bl = isValid = !(virtualFileManager.getStructureModificationCount() != mapping.getFileOrFsModificationStamp() || sourceContent != null && sourceContent.hashCode() != mapping.getContentHashCode() || script != null && script.hashCode() != mapping.getScriptHashCode());
        }
        if (!isValid) {
            this.urlToFileMap.remove(mapping.getUrl());
            this.fileToUrlMap.remove((Object)mapping.getFile());
        }
        return isValid;
    }

    static /* synthetic */ boolean checkMappingIsValid$default(JSFileUrlMappings jSFileUrlMappings, FileUrlMapping fileUrlMapping, boolean bl, String string, Script script, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            script = null;
        }
        return jSFileUrlMappings.checkMappingIsValid(fileUrlMapping, bl, string, script);
    }

    public JSFileUrlMappings() {
        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.newConcurrentMap()");
        this.urlToFileMap = concurrentMap;
        MultiMap multiMap = ConcurrentMultiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)multiMap, (String)"ConcurrentMultiMap.create()");
        this.fileToUrlMap = multiMap;
    }
}

