/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.jetbrains.php.phing.PhingBuildFile;
import org.jetbrains.annotations.Nullable;

public class PhingBuildTarget {
    private final boolean isDefault;
    private final boolean isHiddenByAttribute;
    private final String name;
    private final String description;
    private final VirtualFile myFile;
    private final PhingBuildFile myContextFile;
    private final int myTextOffset;

    public PhingBuildTarget(String name, String description, boolean aDefault, VirtualFile file, int textOffset, PhingBuildFile contextFile, boolean hiddenByTag) {
        this.isDefault = aDefault;
        this.name = name;
        this.description = description;
        this.myFile = file;
        this.myContextFile = contextFile;
        this.myTextOffset = textOffset;
        this.isHiddenByAttribute = hiddenByTag;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public Navigatable getOpenFileDescriptor() {
        return this.myFile == null ? null : PsiNavigationSupport.getInstance().createNavigatable(this.getProject(), this.myFile, this.myTextOffset);
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public VirtualFile getContextFile() {
        return this.myContextFile.getFile();
    }

    public PhingBuildFile getContextBuildFile() {
        return this.myContextFile;
    }

    public Project getProject() {
        return this.myContextFile.getProject();
    }

    public boolean isHiddenByAttribute() {
        return this.isHiddenByAttribute;
    }
}

