/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.database.dataSource.connection.statements.CallableSmartStatement;
import com.intellij.database.dataSource.connection.statements.CallableStatementData;
import com.intellij.database.dataSource.connection.statements.ExecutionMode;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.connection.statements.StandardExecutionMode;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dataSource.connection.statements.StatementParameters;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.dialects.db2.AbstractDb2Dialect;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Locale;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Db2Dialect
extends AbstractDb2Dialect
implements DatabaseDialect {
    public static final Db2Dialect INSTANCE = new Db2Dialect();
    private String myExplainPlanQuery;

    public Db2Dialect() {
        super(new TypeHelper.DB2TypeHelper(), Casing.create((Case)Case.UPPER, (Case)Case.EXACT));
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.DB2;
        if (dbms == null) {
            Db2Dialect.$$$reportNull$$$0(0);
        }
        return dbms;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.DB2;
        if (icon == null) {
            Db2Dialect.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("Db2" == null) {
            Db2Dialect.$$$reportNull$$$0(2);
        }
        return "Db2";
    }

    @NotNull
    private static String sysCat(@NotNull DasObject element2) {
        if (element2 == null) {
            Db2Dialect.$$$reportNull$$$0(3);
        }
        Object dataSource = element2 instanceof DbElement ? ((DbElement)element2).getDataSource() : (element2 instanceof BasicElement ? Db2Dialect.findDataSource(element2) : null);
        LocalDataSource localDataSource = dataSource == null ? null : DbImplUtil.getLocalDataSource((DasDataSource)dataSource);
        String url = localDataSource == null ? null : localDataSource.getUrl();
        boolean as400 = url != null && url.contains(":as400:");
        String string = as400 ? "SYSIBM" : "SYSCAT";
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static DbDataSource findDataSource(@NotNull DasObject element2) {
        if (element2 == null) {
            Db2Dialect.$$$reportNull$$$0(5);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DbDataSource dataSource;
            if (project.isDefault() || !project.isOpen() || (dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(element2)) == null) continue;
            return dataSource;
        }
        return null;
    }

    @Override
    public SearchPath tryToLoadSearchPath(@NotNull DasDataSource system, @NotNull DatabaseConnection connection2) throws SQLException {
        Dbms dbms;
        String s;
        if (system == null) {
            Db2Dialect.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            Db2Dialect.$$$reportNull$$$0(7);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtil.concatStringResults(connection2, dbms = connection2.getDbms(), "values (current_schema)", 1, DbImplUtil.ConcatenationProps.LINES))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            Db2Dialect.$$$reportNull$$$0(8);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", current.getName());
    }

    @Override
    @Nullable
    public String getNameForKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            Db2Dialect.$$$reportNull$$$0(9);
        }
        return kind == ObjectKind.PACKAGE ? "MODULE" : super.getNameForKind(kind);
    }

    @NotNull
    public DdlBuilder generated(@NotNull DdlBuilder builder) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(10);
        }
        DdlBuilder ddlBuilder = builder.space().keywords("GENERATED", "ALWAYS", "AS", "IDENTITY").plain("(").keywords("START", "WITH").space().literal("1").space().keywords("INCREMENT", "BY").space().literal("1").plain(")");
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(11);
        }
        return ddlBuilder;
    }

    @Override
    public boolean supportsAlterColumnType() {
        return true;
    }

    @Override
    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasObject sequence, boolean cascade) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(12);
        }
        if (sequence == null) {
            Db2Dialect.$$$reportNull$$$0(13);
        }
        DdlBuilder ddlBuilder = DialectUtils.getDropSequenceSQL(builder, sequence, false);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(14);
        }
        return ddlBuilder;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element2) {
        if (element2 == null) {
            Db2Dialect.$$$reportNull$$$0(15);
        }
        return Pair.create((Object)("SELECT TEXT FROM " + Db2Dialect.sysCat(element2) + ".VIEWS WHERE VIEWSCHEMA = '" + DasUtil.getSchema((DasObject)element2) + "' AND UPPER(VIEWNAME) = '" + element2.getName().toUpperCase(Locale.ENGLISH) + "'"), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return true;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element2) {
        if (element2 == null) {
            Db2Dialect.$$$reportNull$$$0(16);
        }
        StringBuilder createViewSql = new StringBuilder();
        DasRoutine.Kind type = element2.getRoutineKind();
        createViewSql.append("SELECT TEXT FROM ").append(Db2Dialect.sysCat((DasObject)element2)).append(".ROUTINES").append(" WHERE ROUTINESCHEMA='");
        createViewSql.append(DasUtil.getSchema((DasObject)element2));
        createViewSql.append("' AND UPPER(ROUTINENAME) = '");
        createViewSql.append(element2.getName().toUpperCase(Locale.ENGLISH));
        createViewSql.append("' AND ROUTINETYPE = '");
        createViewSql.append(type == DasRoutine.Kind.FUNCTION ? "F" : "P");
        createViewSql.append("'");
        Pair pair = Pair.create((Object)createViewSql.toString(), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
        if (pair == null) {
            Db2Dialect.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    @Override
    public boolean supportsInsertDefaultIntoAutoVal() {
        return true;
    }

    @Override
    public boolean supportsTableDefinition() {
        return true;
    }

    @Override
    @NotNull
    public String tryToLoadTableDefinition(@NotNull DasTable table, @NotNull DatabaseConnection connection2) throws Exception {
        if (table == null) {
            Db2Dialect.$$$reportNull$$$0(18);
        }
        if (connection2 == null) {
            Db2Dialect.$$$reportNull$$$0(19);
        }
        CallableSmartStatement statement = SmartStatements.poweredBy(connection2).call();
        CallableStatementData data = new StatementParameters().text(QNameUtil.getQualifiedName((DasObject)table)).parameter(2, 4).asCallData("CALL SYSPROC.DB2LK_GENERATE_DDL('-e -td ; -t ' || ?, ?)");
        Either token = statement.execute(data, (ExecutionMode)StandardExecutionMode.UPDATE, StandardResultsProcessors.parameterRetriever(2));
        Dbms dbms = connection2.getDbms();
        String string = token.isLeft() ? "Failed to load table definition" : StringUtil.trimEnd((String)DbImplUtil.concatStringResults(connection2, dbms, "SELECT SQL_STMT FROM SYSTOOLS.DB2LOOK_INFO WHERE OP_TOKEN = " + token.tryGet(), 1, DbImplUtil.ConcatenationProps.NO_CONCAT), (String)";");
        if (string == null) {
            Db2Dialect.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            Db2Dialect.$$$reportNull$$$0(21);
        }
        if (!Character.isLetter(identifier.charAt(0))) {
            return false;
        }
        int len = identifier.length();
        for (int i2 = 1; i2 < len; ++i2) {
            char c2 = identifier.charAt(i2);
            if (Character.isLetterOrDigit(c2) || c2 == '_' || c2 == '$' || c2 == '#') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    private void ensureScriptLoaded() {
        if (this.myExplainPlanQuery == null) {
            try (InputStream stream = Db2Dialect.class.getResourceAsStream("plan/db2.explain_last.sql");){
                this.myExplainPlanQuery = new String(FileUtil.adaptiveLoadText((Reader)new InputStreamReader(stream, CharsetToolkit.UTF8_CHARSET)));
                return;
            }
            catch (IOException iOException) {
                this.myExplainPlanQuery = "";
            }
        }
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(22);
        }
        if (statement == null) {
            Db2Dialect.$$$reportNull$$$0(23);
        }
        this.ensureScriptLoaded();
        if (this.myExplainPlanQuery.isEmpty()) {
            throw new UnsupportedOperationException("explain_last script not found");
        }
        builder.keywords("explain", "plan").space().keyword("for").space().plain(statement).newStatement().plain(this.myExplainPlanQuery);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(24);
        }
        return ddlBuilder;
    }

    @Override
    public boolean hasRowId(@Nullable DasDataSource system) {
        Version version = system == null ? null : system.getVersion();
        return version == null || version.isOrGreater(new int[]{9, 4});
    }

    @Override
    @NotNull
    protected DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable DasDataSource system) {
        if (builder == null) {
            Db2Dialect.$$$reportNull$$$0(25);
        }
        String ridCall = String.format("RID(%s) as \"RID(%s)\"", "t", "t");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal(ridCall);
        if (ddlBuilder == null) {
            Db2Dialect.$$$reportNull$$$0(26);
        }
        return ddlBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/db2/Db2Dialect";
                break;
            }
            case 3: 
            case 5: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "system";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/db2/Db2Dialect";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "sysCat";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generated";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropSequence";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlProcedureDefinition";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableDefinition";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlExplainPlan";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "appendRowId";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sysCat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findDataSource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNameForKind";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generated";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropSequence";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sqlViewDefinition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sqlProcedureDefinition";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableDefinition";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isValidPlainIdentifier";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sqlExplainPlan";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendRowId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

