/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redshift.plan;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.postgres.plan.PostgresPlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedshiftPlanModelBuilder
extends AbstractPlanModelBuilder<MetaNode> {
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING_EXT = ContainerUtil.newHashMap();
    public static final String SUBQUERY_SCAN = "Subquery Scan";
    @Language(value="Regexp")
    private static final String NAME = "(?:\"(?:[^\"]|\"\")*\"|(\\w|_)+)";
    private static final Pattern TABLE_PATTERN;
    private static final Pattern INDEX_PATTERN;
    private static final Pattern ATTR_PATTERN;
    private final String myStatement;
    private List<String> myLines;

    public RedshiftPlanModelBuilder(@NotNull DataRequest.OwnerEx owner, @NotNull Consumer<PlanModel> consumer2, @NotNull String statement) {
        if (owner == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(0);
        }
        if (consumer2 == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(1);
        }
        if (statement == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(2);
        }
        super(owner, consumer2, EnumSet.noneOf(PlanModel.Feature.class));
        this.myStatement = statement;
    }

    @NotNull
    private List<String> getPlanLines(@NotNull DatabaseConnection connection2) throws PlanRetrievalException {
        if (connection2 == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(3);
        }
        final ArrayList result2 = ContainerUtil.newArrayList();
        RedshiftPlanModelBuilder.useStatementWithPreserved(connection2, new AbstractPlanModelBuilder.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> statement) throws PlanRetrievalException, SQLException {
                statement.noisy().execute("EXPLAIN " + RedshiftPlanModelBuilder.this.myStatement, RedshiftPlanModelBuilder.processing((ThrowableConsumer<ResultSet, SQLException>)rs -> {
                    if (!rs.next()) {
                        RedshiftPlanModelBuilder.failWithEmptyResultSetError();
                    }
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    do {
                        String res2;
                        if ((res2 = rs.getString(1)) == null) {
                            throw new PlanRetrievalException("Database returned null plan");
                        }
                        result2.add(res2);
                    } while (rs.next());
                }));
            }
        }, new AbstractPlanModelBuilder.StateSaver[0]);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private void parseRoot() throws PlanRetrievalException {
        if (this.myLines.size() == 0) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        this.openNode();
        this.parseStatement(new MetaNode(0, this.myLines.size(), 0));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String dump() {
        String string = StringUtil.join(this.myLines, (String)"\n");
        if (string == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void processRaw(@NotNull DataRequest.Context context, @NotNull DatabaseConnection connection2) {
        if (context == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (connection2 == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(7);
        }
        this.myLines = this.getPlanLines(connection2);
        this.showRaw();
        this.parseRoot();
        this.modelReady();
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(8);
        }
        if ("" == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull MetaNode state) {
        Matcher matcher;
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return (matcher = TABLE_PATTERN.matcher(this.myLines.get(state.line))).find(state.indent) ? matcher.group(1) : null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull MetaNode state) {
        Matcher matcher;
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return (matcher = INDEX_PATTERN.matcher(this.myLines.get(state.line))).find(state.indent) ? matcher.group(1) : null;
    }

    @Override
    protected void parseSubPlans(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(13);
        }
        int subIndent = state.indent + 6;
        int prev = -1;
        for (int i2 = state.line; i2 <= state.end; ++i2) {
            if (i2 != state.end && !RedshiftPlanModelBuilder.isSubNode(state.indent, this.myLines.get(i2))) continue;
            if (prev != -1) {
                this.parsePlan(new MetaNode(prev, i2, subIndent));
            }
            prev = i2;
        }
    }

    @Override
    protected void parseStatement(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(14);
        }
        this.openNode();
        this.parsePlan(state);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.SELECT, null));
    }

    @Override
    protected void parseNode(@NotNull MetaNode state, @NotNull PlanModel.GenericNode node) {
        String extra;
        String line;
        Matcher matcher;
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(15);
        }
        if (node == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(16);
        }
        if (!(matcher = ATTR_PATTERN.matcher(line = this.myLines.get(state.line))).find(state.indent)) {
            throw new PlanRetrievalException("Unable to find cost in: " + line);
        }
        String string = extra = state.line + 1 < state.end ? this.myLines.get(state.line + 1) : null;
        if (extra != null && RedshiftPlanModelBuilder.isSubNode(state.indent, extra)) {
            extra = null;
        }
        if (extra != null) {
            extra = extra.substring(state.indent + 2);
        }
        ArrayList infos = ContainerUtil.newArrayListWithCapacity((int)4);
        ContainerUtil.addIfNotNull((Collection)infos, (Object)state.tp);
        ContainerUtil.addIfNotNull((Collection)infos, (Object)matcher.group(1));
        ContainerUtil.addIfNotNull((Collection)infos, (Object)matcher.group(5));
        ContainerUtil.addIfNotNull((Collection)infos, (Object)extra);
        node.setRawDescription(StringUtil.join((Collection)infos, (String)"; \n"));
        node.setPlanNumRows(new BigDecimal(matcher.group(4)));
        node.setTotalCost(Double.parseDouble(matcher.group(3)));
        node.setStartupCost(Double.parseDouble(matcher.group(2)));
    }

    private static boolean isSubNode(int indent, String line) {
        return StringUtil.startsWith((CharSequence)line, (int)(indent + 2), (CharSequence)"->");
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(17);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(19);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(20);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull MetaNode state) {
        if (state == null) {
            RedshiftPlanModelBuilder.$$$reportNull$$$0(21);
        }
        this.openNode();
        this.parseSubPlans(state);
        String line = this.myLines.get(state.line);
        int s = state.indent;
        int t = line.indexOf(32, s);
        if (t == -1) {
            throw new PlanRetrievalException("Unable to parse line: " + line);
        }
        state.tp = line.substring(s, t);
        if (StringUtil.startsWith((CharSequence)line, (int)(s = ++t), (CharSequence)SUBQUERY_SCAN)) {
            t = s + SUBQUERY_SCAN.length();
        } else {
            while ((t = line.indexOf(32, t + 1)) != -1 && !RedshiftPlanModelBuilder.isEOType(line, t)) {
            }
        }
        String nodeType = (t == -1 ? line.substring(s) : line.substring(s, t)).trim();
        PlanModel.NodeType type = PostgresPlanModelBuilder.TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = TYPE_MAPPING_EXT.get(nodeType);
        }
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, nodeType);
        this.closeNode(node);
    }

    private static boolean isEOType(String line, int t) {
        return StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"on") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"using") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"DS_") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"(");
    }

    static {
        TYPE_MAPPING_EXT.put("Hash Left Join", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING_EXT.put("Network", PlanModel.NodeType.NETWORK);
        TABLE_PATTERN = Pattern.compile("\\s(?:on|Subquery Scan) ((?:\"(?:[^\"]|\"\")*\"|(\\w|_)+))\\s+\\(cost[^()]+\\)");
        INDEX_PATTERN = Pattern.compile("\\susing ((?:\"(?:[^\"]|\"\")*\"|(\\w|_)+))\\s+(?:on (?:\"(?:[^\"]|\"\")*\"|(\\w|_)+)\\s+)?\\(cost[^()]+\\)");
        ATTR_PATTERN = Pattern.compile("(\\bDS_\\S+)?\\s*\\(cost=(\\d+\\.\\d+)\\.\\.(\\d+\\.\\d+) rows=(\\d+) (.*)\\)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/redshift/plan/RedshiftPlanModelBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/redshift/plan/RedshiftPlanModelBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanLines";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlanLines";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processRaw";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "parseNode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MetaNode {
        final int line;
        final int end;
        final int indent;
        String tp;

        public MetaNode(int line, int end, int indent) {
            this.line = line;
            this.end = end;
            this.indent = indent;
        }
    }
}

