/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.Commenter;
import com.intellij.lang.CustomUncommenter;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.editing.JavascriptCommenter;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXCommentProvider
implements MultipleLangCommentProvider {
    @Nullable
    public Commenter getLineCommenter(PsiFile file2, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        PsiElement at = JSXCommentProvider.findFirstElementOnLine(file2, editor);
        return JSXCommentProvider.isTagBodyContext(at) ? new JSXCommenter() : new JavascriptCommenter();
    }

    public static boolean isTagBodyContext(@Nullable PsiElement at) {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)at, XmlTag.class, (boolean)false);
        JSEmbeddedContent script = JSXCommentProvider.notAtScriptStart(at) ? (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)at, JSEmbeddedContent.class, (boolean)false, (Class[])new Class[]{XmlTag.class}) : null;
        return tag != null && !(at.getParent() instanceof XmlAttribute) && !(at instanceof PsiComment) && script == null || JSXCommentProvider.isJsxComment(at);
    }

    private static boolean notAtScriptStart(PsiElement at) {
        return at != null && (at.getNode().getElementType() != JSTokenTypes.LBRACE || !(at.getParent() instanceof JSEmbeddedContent));
    }

    private static boolean isJsxComment(@Nullable PsiElement at) {
        PsiElement parent = at != null ? at.getParent() : null;
        return parent instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)parent).getFirstProperty() == null && at.getNextSibling() instanceof PsiComment;
    }

    @Nullable
    private static PsiElement findFirstElementOnLine(PsiFile file2, Editor editor) {
        int number;
        Document document = editor.getDocument();
        int offset = document.getLineStartOffset(number = document.getLineNumber(editor.getSelectionModel().getSelectionStart()));
        PsiElement at = file2.findElementAt(offset);
        if (at instanceof PsiWhiteSpace) {
            PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)at);
            return next != null && document.getLineNumber(next.getTextRange().getStartOffset()) == number ? next : at;
        }
        return at;
    }

    public boolean canProcess(PsiFile file2, FileViewProvider viewProvider) {
        return DialectDetector.isJSX((PsiElement)file2) && !DialectDetector.isCoffeeScript((PsiElement)file2);
    }

    private static class JSXCommenter
    extends JavascriptCommenter
    implements CustomUncommenter {
        private JSXCommenter() {
        }

        @Override
        public String getLineCommentPrefix() {
            return null;
        }

        @Override
        @NotNull
        public String getBlockCommentPrefix() {
            if ("{/*" == null) {
                JSXCommenter.$$$reportNull$$$0(0);
            }
            return "{/*";
        }

        @Override
        @NotNull
        public String getBlockCommentSuffix() {
            if ("*/}" == null) {
                JSXCommenter.$$$reportNull$$$0(1);
            }
            return "*/}";
        }

        @Nullable
        public TextRange findMaximumCommentedRange(@NotNull CharSequence text) {
            if (text == null) {
                JSXCommenter.$$$reportNull$$$0(2);
            }
            int start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentPrefix(), (int)0);
            int end = CharArrayUtil.lastIndexOf((CharSequence)text, (String)this.getBlockCommentSuffix(), (int)text.length());
            return start >= 0 && end >= start ? new TextRange(start, end + this.getBlockCommentSuffix().length()) : null;
        }

        @NotNull
        public Collection<? extends Couple<TextRange>> getCommentRangesToDelete(@NotNull CharSequence text) {
            if (text == null) {
                JSXCommenter.$$$reportNull$$$0(3);
            }
            SmartList result2 = new SmartList();
            int start = 0;
            int end = 0;
            while (start >= 0 && end >= start) {
                start = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentPrefix(), (int)end);
                end = CharArrayUtil.indexOf((CharSequence)text, (CharSequence)this.getBlockCommentSuffix(), (int)start);
                if (start < 0 || end < start) continue;
                result2.add((Object)Couple.of((Object)new TextRange(start, start + this.getBlockCommentPrefix().length()), (Object)new TextRange(end, end + this.getBlockCommentSuffix().length())));
            }
            SmartList smartList = result2;
            if (smartList == null) {
                JSXCommenter.$$$reportNull$$$0(4);
            }
            return smartList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/JSXCommentProvider$JSXCommenter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlockCommentPrefix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBlockCommentSuffix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/JSXCommentProvider$JSXCommenter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentRangesToDelete";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findMaximumCommentedRange";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommentRangesToDelete";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

