/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptReferenceSet;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.impl.JSTextReference;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlToken;
import org.jetbrains.annotations.NotNull;

public class ActionScriptTextReferenceResolver {
    @NotNull
    public static ResolveResult[] resolve(@NotNull JSTextReference reference) {
        if (reference == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(0);
        }
        PsiFile psiFile = reference.mySet.element.getContainingFile();
        String text = reference.myCanonicalText;
        MyResolveProcessor processor = new MyResolveProcessor(text, (PsiElement)psiFile, new ResolveResultSink((PsiElement)psiFile, text), reference);
        ActionScriptTextReferenceResolver.doProcess(reference, psiFile, processor);
        ResolveResult[] resolveResultArray = processor.getResultsAsResolveResults();
        if (resolveResultArray == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(1);
        }
        return resolveResultArray;
    }

    public static void processToSink(@NotNull JSTextReference reference, @NotNull PsiFile containingFile, @NotNull ResultSink resultSink) {
        if (reference == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(3);
        }
        if (resultSink == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(4);
        }
        MyResolveProcessor processor = new MyResolveProcessor(resultSink.getName(), resultSink.place, resultSink, reference);
        ActionScriptTextReferenceResolver.doProcess(reference, containingFile, processor);
    }

    private static void doProcess(JSTextReference reference, PsiFile psiFile, SinkResolveProcessor processor) {
        PsiElement nearestClass = ActionScriptTextReferenceResolver.findNearestClass(reference);
        int index = ActionScriptTextReferenceResolver.calcMyIndex(reference);
        JSReferenceSet referenceSet = reference.mySet;
        if (index == 0) {
            if ("this".equals(reference.myCanonicalText) && nearestClass instanceof JSClass) {
                processor.addResult(nearestClass);
                return;
            }
            if (reference.myRangeInElement.getStartOffset() > 0) {
                if (nearestClass instanceof JSClass && !(referenceSet.element instanceof JSLiteralExpression)) {
                    processor.setToProcessHierarchy(true);
                    processor.setTypeContext(true);
                    processor.configureClassScope((JSClass)nearestClass);
                    if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                        return;
                    }
                }
            } else if (nearestClass instanceof JSClass) {
                processor.setTypeContext(true);
                processor.setToProcessMembers(false);
                if (!nearestClass.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), nearestClass, nearestClass)) {
                    return;
                }
                boolean isOnlyFqns = ActionScriptTextReferenceResolver.isOnlyFqns(referenceSet);
                if (!isOnlyFqns && referenceSet.element instanceof JSDocTagValue) {
                    String packageName = JSResolveUtil.getPackageName(nearestClass);
                    processor.setForcedPackageName(packageName);
                    String classQName = !packageName.isEmpty() ? packageName + "." + reference.myCanonicalText : reference.myCanonicalText;
                    PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(nearestClass).getClassResolver().findClassByQName(classQName, nearestClass);
                    if (clazz != null && !clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), clazz, clazz)) {
                        return;
                    }
                }
            }
            PsiElement startFrom = referenceSet.element;
            PsiElement lastParent = referenceSet.element.getParent();
            if (referenceSet.element instanceof JSLiteralExpression) {
                JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceSet.element, JSFunction.class);
                while (fun != null) {
                    startFrom = fun;
                    lastParent = fun.getParent();
                    fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)fun, JSFunction.class);
                }
            }
            JSResolveUtil.treeWalkUp(processor, startFrom, lastParent, referenceSet.element);
            if (!(psiFile instanceof JSFile) && !(psiFile instanceof XmlFile) && psiFile.getContext() == null) {
                JSResolveUtil.processGlobalThings(processor, ResolveState.initial(), (PsiElement)psiFile, (PsiElement)psiFile);
            }
        } else {
            PsiElement psiElement = referenceSet.myReferences[index - 1].resolve();
            if (psiElement instanceof JSOffsetBasedImplicitElement && ((JSOffsetBasedImplicitElement)psiElement).getType() == JSImplicitElement.Type.Tag) {
                psiElement = ((JSOffsetBasedImplicitElement)psiElement).getElementAtOffset();
            }
            if (psiElement instanceof XmlToken) {
                JSTagContextBuilder builder = new JSTagContextBuilder(psiElement, "HTMLElement");
                psiElement = builder.element;
            }
            if (psiElement != null) {
                JSType type = null;
                if (psiElement instanceof JSVariable) {
                    type = ((JSVariable)psiElement).getType();
                } else if (psiElement instanceof JSFunction && ((JSFunction)psiElement).isGetProperty()) {
                    type = ((JSFunction)psiElement).getReturnType();
                }
                if (type != null) {
                    String typeText = type.getTypeText();
                    typeText = JSTypeUtils.getTypeMatchingNamespace(typeText);
                    String qname = JSImportHandlingUtil.resolveTypeName(typeText, psiElement);
                    assert (qname != null);
                    PsiElement typeClass = JSClassResolver.findClassFromNamespace(qname, psiElement);
                    if (typeClass instanceof JSClass) {
                        psiElement = typeClass;
                    }
                }
                if (psiElement instanceof JSClass) {
                    processor.setToProcessHierarchy(true);
                }
                String packageName = null;
                if (psiElement instanceof JSPackageWrapper) {
                    packageName = ((JSPackageWrapper)psiElement).getQualifiedName();
                } else if (psiElement instanceof JSClass) {
                    packageName = JSResolveUtil.getPackageName(psiElement);
                }
                if (packageName != null) {
                    processor.setForcedPackageName(packageName);
                }
                if (psiElement instanceof JSClass) {
                    processor.configureClassScope((JSClass)psiElement);
                    processor.setAllowUnqualifiedStaticsFromInstance(true);
                }
                psiElement.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), psiElement, psiElement);
            }
        }
        if (psiFile instanceof XmlFile && !JavaScriptSupportLoader.isMxmlOrFxgFile(psiFile)) {
            JSResolveUtil.processTopLevelClasses(processor, ResolveState.initial(), psiFile.getProject(), JSResolveUtil.getResolveScope((PsiElement)psiFile), ActionScriptTextReferenceResolver.isOnlyFqns(referenceSet) ? JSResolveUtil.GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : JSResolveUtil.GlobalSymbolsAcceptanceState.WHATEVER, false);
        }
    }

    private static boolean isOnlyFqns(@NotNull JSReferenceSet referenceSet) {
        if (referenceSet == null) {
            ActionScriptTextReferenceResolver.$$$reportNull$$$0(5);
        }
        return referenceSet instanceof ActionScriptReferenceSet && ((ActionScriptReferenceSet)referenceSet).isOnlyFqns();
    }

    private static int calcMyIndex(JSTextReference reference) {
        int i;
        for (i = 0; i < reference.mySet.myReferences.length && reference.mySet.myReferences[i] != reference; ++i) {
        }
        return i;
    }

    private static PsiElement findNearestClass(JSTextReference reference) {
        PsiElement originalElement;
        PsiElement parent;
        PsiElement elt = reference.mySet.element;
        PsiElement candidateBlock = null;
        while (!((parent = elt.getParent()) instanceof JSFile || parent instanceof JSPackageStatement || parent instanceof XmlTagChild)) {
            if (parent instanceof JSBlockStatement) {
                candidateBlock = elt;
            }
            if ((elt = parent) != null && !(elt instanceof JSClass)) continue;
        }
        if (parent instanceof XmlTag) {
            if (XmlBackedJSClassImpl.isComponentTag((XmlTag)parent)) {
                XmlTag[] subtags = ((XmlTag)parent).getSubTags();
                if (subtags.length > 0) {
                    elt = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]);
                }
            } else {
                XmlFile xmlFile = (XmlFile)parent.getContainingFile();
                if (JavaScriptSupportLoader.isMxmlOrFxgFile((PsiFile)xmlFile)) {
                    elt = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
                }
            }
        }
        if (elt != null && !(elt instanceof JSClass) && candidateBlock != null) {
            elt = candidateBlock;
        }
        if (elt != null && (originalElement = CompletionUtilCoreImpl.getOriginalElement((PsiElement)elt)) != null) {
            elt = originalElement;
        }
        return elt;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/ActionScriptTextReferenceResolver";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/ActionScriptTextReferenceResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processToSink";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isOnlyFqns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyResolveProcessor
    extends SinkResolveProcessor<ResultSink> {
        private String normalizedQN;
        private final JSTextReference myReference;

        MyResolveProcessor(String name, PsiElement _place, @NotNull ResultSink sink, JSTextReference reference) {
            if (sink == null) {
                MyResolveProcessor.$$$reportNull$$$0(0);
            }
            super(name, _place, sink);
            this.myReference = reference;
        }

        @Override
        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            String qName;
            JSReferenceSet referenceSet;
            if (element == null) {
                MyResolveProcessor.$$$reportNull$$$0(1);
            }
            if (state == null) {
                MyResolveProcessor.$$$reportNull$$$0(2);
            }
            if (ActionScriptTextReferenceResolver.isOnlyFqns(referenceSet = this.myReference.mySet)) {
                if (!(element instanceof JSPackageWrapper) && !(element instanceof JSClass)) {
                    return true;
                }
                if (this.myName != null && element instanceof JSClass && this.myName.equals(((JSClass)element).getName())) {
                    if (this.normalizedQN == null) {
                        this.normalizedQN = StringUtil.unquoteString((String)referenceSet.myReferenceText).replace(':', '.');
                    }
                    if (!this.normalizedQN.equals(((JSClass)element).getQualifiedName())) {
                        return true;
                    }
                }
            }
            if (referenceSet.myOnlyDefaultPackage && element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.isEmpty((String)StringUtil.getPackageName((String)qName))) {
                return true;
            }
            return super.execute(element, state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/impl/ActionScriptTextReferenceResolver$MyResolveProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

