/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventAction;
import com.intellij.internal.statistic.eventLog.LogEventJsonDeserializer;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.openapi.diagnostic.Logger;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventSerializer;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "fromString", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "line", "", "toJson", "Lcom/google/gson/JsonObject;", "event", "toString", "request", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "session", "writer", "Ljava/io/OutputStreamWriter;", "intellij.platform.ide.impl"})
public final class LogEventSerializer {
    private static final Logger LOG;
    private static final Gson gson;
    public static final LogEventSerializer INSTANCE;

    public final void toString(@NotNull LogEventRecordRequest session2, @NotNull OutputStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.write(this.toString(session2));
    }

    @NotNull
    public final String toString(@NotNull LogEventRecordRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        JsonObject obj = new JsonObject();
        obj.addProperty("product", request.getProduct());
        obj.addProperty("user", request.getUser());
        JsonArray records = new JsonArray();
        for (LogEventRecord record : request.getRecords()) {
            JsonArray events = new JsonArray();
            for (LogEvent event : record.getEvents()) {
                events.add((JsonElement)this.toJson(event));
            }
            JsonObject recordObj = new JsonObject();
            recordObj.add("events", (JsonElement)events);
            records.add((JsonElement)recordObj);
        }
        obj.add("records", (JsonElement)records);
        String string = obj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.toString()");
        return string;
    }

    @NotNull
    public final JsonObject toJson(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        JsonObject obj = new JsonObject();
        obj.addProperty("session", event.getSession());
        obj.addProperty("build", event.getBuild());
        obj.addProperty("bucket", event.getBucket());
        obj.addProperty("time", (Number)event.getTime());
        JsonObject group = new JsonObject();
        group.addProperty("id", event.getGroup().getId());
        group.addProperty("version", event.getGroup().getVersion());
        JsonObject action = new JsonObject();
        if (event.getEvent() instanceof LogEventAction) {
            action.addProperty("count", (Number)((LogEventAction)event.getEvent()).getCount());
        }
        action.add("data", gson.toJsonTree(event.getEvent().getData()));
        action.addProperty("id", event.getEvent().getId());
        obj.add("group", (JsonElement)group);
        obj.add("event", (JsonElement)action);
        return obj;
    }

    @NotNull
    public final String toString(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = this.toJson(event).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toJson(event).toString()");
        return string;
    }

    @Nullable
    public final LogEvent fromString(@NotNull String line) {
        LogEvent logEvent;
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        try {
            logEvent = (LogEvent)gson.fromJson(line, LogEvent.class);
        }
        catch (Exception e) {
            LOG.trace("Failed deserializing event: '" + e.getMessage() + '\'');
            logEvent = null;
        }
        return logEvent;
    }

    private LogEventSerializer() {
    }

    static {
        LogEventSerializer logEventSerializer;
        INSTANCE = logEventSerializer = new LogEventSerializer();
        Logger logger = Logger.getInstance(LogEventSerializer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(LogEventSerializer::class.java)");
        LOG = logger;
        gson = new GsonBuilder().registerTypeAdapter((Type)((Object)LogEvent.class), (Object)new LogEventJsonDeserializer()).create();
    }
}

