/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.EditingSides;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.splitter.DiffDividerPaint;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DiffDivider
extends JComponent {
    public static final int MERGE_DIVIDER_POLYGONS_OFFSET = 1;
    public static final int MERGE_SCROLL_DIVIDER_POLYGONS_OFFSET = 2;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.DiffDivider");
    private final Editor[] myEditors = new Editor[2];
    private final FragmentSide myLeftSide;
    private DiffDividerPaint myPaint = null;
    private static final int ourWidth = 30;
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
            DiffDivider.this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/diff/impl/util/DiffDivider$1", "visibleAreaChanged"));
        }
    };

    public DiffDivider(FragmentSide leftSide) {
        this.myLeftSide = leftSide;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(30, 1);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.myPaint != null) {
            this.myPaint.paint(g, this);
        }
    }

    public DiffDividerPaint getPaint() {
        return this.myPaint;
    }

    public void stopListenEditors() {
        for (int i = 0; i < this.myEditors.length; ++i) {
            Editor editor = this.myEditors[i];
            if (editor == null) continue;
            editor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
            this.myEditors[i] = null;
        }
        this.myPaint = null;
        this.myEditors[0] = null;
        this.myEditors[1] = null;
    }

    public void listenEditors(@NotNull EditingSides sides) {
        if (sides == null) {
            DiffDivider.$$$reportNull$$$0(0);
        }
        this.stopListenEditors();
        this.myPaint = new DiffDividerPaint(sides, this.myLeftSide, 1);
        this.myEditors[0] = sides.getEditor(FragmentSide.SIDE1);
        this.myEditors[1] = sides.getEditor(FragmentSide.SIDE2);
        if (this.myEditors[0] == null || this.myEditors[1] == null) {
            LOG.error(this.myEditors[1] + " " + this.myEditors[1]);
        }
        for (Editor editor : this.myEditors) {
            editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sides", "com/intellij/openapi/diff/impl/util/DiffDivider", "listenEditors"));
    }
}

