/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project.model.impl.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.RootModelBase;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.project.model.impl.module.JpsOrderEntryFactory;
import com.intellij.project.model.impl.module.content.JpsContentEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsRootModel
extends RootModelBase
implements ModuleRootModel {
    private final Module myModule;
    private final JpsModule myJpsModule;
    public VirtualFilePointer myExplodedDirectoryPointer;
    private final List<ContentEntry> myContentEntries;
    private final List<OrderEntry> myOrderEntries;

    public JpsRootModel(Module module, JpsModule jpsModule) {
        this.myModule = module;
        this.myJpsModule = jpsModule;
        this.myContentEntries = new ArrayList<ContentEntry>();
        for (String contentRoot : this.myJpsModule.getContentRootsList().getUrls()) {
            this.myContentEntries.add(new JpsContentEntry(jpsModule, this, contentRoot));
        }
        this.myOrderEntries = new ArrayList<OrderEntry>();
        for (JpsDependencyElement element : this.myJpsModule.getDependenciesList().getDependencies()) {
            this.myOrderEntries.add(JpsOrderEntryFactory.createOrderEntry(this, element));
        }
    }

    public JpsModule getJpsModule() {
        return this.myJpsModule;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            JpsRootModel.$$$reportNull$$$0(0);
        }
        return module;
    }

    @Override
    protected Collection<ContentEntry> getContent() {
        return this.myContentEntries;
    }

    @NotNull
    public OrderEntry[] getOrderEntries() {
        OrderEntry[] orderEntryArray = this.myOrderEntries.toArray(OrderEntry.EMPTY_ARRAY);
        if (orderEntryArray == null) {
            JpsRootModel.$$$reportNull$$$0(1);
        }
        return orderEntryArray;
    }

    public <T> T getModuleExtension(@NotNull Class<T> klass) {
        if (klass == null) {
            JpsRootModel.$$$reportNull$$$0(2);
        }
        throw new UnsupportedOperationException("'getModuleExtension' not implemented in " + this.getClass().getName());
    }

    public Project getProject() {
        return this.myModule.getProject();
    }

    public boolean isExcludeExplodedDirectory() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/project/model/impl/module/JpsRootModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderEntries";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/project/model/impl/module/JpsRootModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

