from compose.cli import main

original_build_container_options = main.build_container_options


def new_build_container_options(options, detach, command):
    """
    Modifies compose.cli.main.build_container_options() to always open stdin.

    This change allows IDE attach to stdin of a docker-compose service while
    running it in detached mode.
    """
    container_options = original_build_container_options(options, detach, command)
    container_options['stdin_open'] = True
    return container_options


main.build_container_options = new_build_container_options
