/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.configuration;

import com.projectlibre1.configuration.ConfigurationReader;
import com.projectlibre1.configuration.FieldDictionary;
import com.projectlibre1.configuration.ProvidesDigesterEvents;
import com.projectlibre1.configuration.ScriptConfiguration;
import com.projectlibre1.field.Field;
import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.timescale.TimeScaleManager;
import com.projectlibre1.util.ClassUtils;
import java.util.Collection;
import org.apache.commons.digester.Digester;

public class Configuration
implements ProvidesDigesterEvents {
    FieldDictionary fieldDictionary = null;
    TimeScaleManager timeScales = null;
    GraphicConfiguration graphicConfiguation = null;
    ScriptConfiguration scriptConfiguration = null;
    private static Configuration instance = null;

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            String[] stringArray;
            instance = new Configuration();
            for (String string : stringArray = Messages.getMetaString("ConfigurationFiles").split(";")) {
                ConfigurationReader.read(string, instance);
            }
            instance.setDonePopulating();
        }
        return instance;
    }

    public void setDonePopulating() {
        this.fieldDictionary.setDonePopulating();
    }

    public FieldDictionary getFieldDictionary() {
        return this.fieldDictionary;
    }

    public void setFieldDictionary(FieldDictionary fieldDictionary) {
        this.fieldDictionary = fieldDictionary;
    }

    public static Field getFieldFromId(String string) {
        return Configuration.getInstance().getFieldDictionary().getFieldFromId(string);
    }

    public static final Field getFieldFromShortId(String string) {
        return Configuration.getFieldFromId("Field." + string);
    }

    public static Collection getAllFields() {
        return Configuration.getInstance().getFieldDictionary().getAllFields();
    }

    public TimeScaleManager getTimeScales() {
        return this.timeScales;
    }

    public void setTimeScales(TimeScaleManager timeScaleManager) {
        this.timeScales = timeScaleManager;
    }

    public void setIntConstant(String string, int n) {
        ClassUtils.setStaticField(string, n);
    }

    public void setStringConstant(String string, String string2) {
        ClassUtils.setStaticField(string, string2);
    }

    public GraphicConfiguration getGraphicConfiguation() {
        return this.graphicConfiguation;
    }

    public void setGraphicConfiguation(GraphicConfiguration graphicConfiguration) {
        this.graphicConfiguation = graphicConfiguration;
    }

    public ScriptConfiguration getScriptConfiguration() {
        return this.scriptConfiguration;
    }

    public void setScriptConfiguration(ScriptConfiguration scriptConfiguration) {
        this.scriptConfiguration = scriptConfiguration;
    }

    private void addGlobalDigesterEvents(Digester digester) {
        digester.addCallMethod("configuration/constants/int", "setIntConstant", 2, new Class[]{String.class, Integer.class});
        digester.addCallParam("configuration/constants/int/name", 0);
        digester.addCallParam("configuration/constants/int/value", 1);
        digester.addCallMethod("configuration/constants/String", "setStringConstant", 2, new Class[]{String.class, String.class});
        digester.addCallParam("configuration/constants/String/name", 0);
        digester.addCallParam("configuration/constants/String/value", 1);
    }

    @Override
    public void addDigesterEvents(Digester digester) {
        this.addGlobalDigesterEvents(digester);
        FieldDictionary.addDigesterEvents(digester);
        TimeScaleManager.addDigesterEvents(digester);
        ScriptConfiguration.addDigesterEvents(digester);
        GraphicConfiguration.addDigesterEvents(digester);
    }
}

