/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;

public class Nilled
extends SystemFunctionCall
implements Callable {
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.useContextItemAsDefault(visitor);
        return this.simplifyArguments(visitor);
    }

    public int getIntrinsicDependencies() {
        if (this.getNumberOfArguments() == 0) {
            return 2;
        }
        return super.getIntrinsicDependencies();
    }

    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        NodeInfo node = (NodeInfo)this.argument[0].evaluateItem(c);
        return Nilled.getNilledProperty(node);
    }

    public static BooleanValue getNilledProperty(NodeInfo node) {
        if (node == null || node.getNodeKind() != 1) {
            return null;
        }
        return BooleanValue.get(node.isNilled());
    }

    public static boolean isNilled(NodeInfo node) {
        BooleanValue b = Nilled.getNilledProperty(node);
        return b != null && b.getBooleanValue();
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo node = this.getDefaultArgumentNode(context, arguments, "fn:nilled()");
        if (node == null || node.getNodeKind() != 1) {
            return EmptySequence.getInstance();
        }
        return BooleanValue.get(Nilled.isNilled(node));
    }
}

