/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.dockablewindows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import org.fife.ui.SubstanceUtils;
import org.fife.ui.dockablewindows.DockableWindowUtil;

class DockedWindowTabbedPaneUI
extends BasicTabbedPaneUI {
    private List croppedTitlesList = new ArrayList();
    private Paint unselectedTabPaint;
    private static final int SELECTED_TAB_BOOST = 1;

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        int height = super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
        if (this.tabPane.getSelectedIndex() == tabIndex) {
            ++height;
        }
        return height;
    }

    protected LayoutManager createLayoutManager() {
        return new PluginTabbedPaneLayout();
    }

    public static ComponentUI createUI(JComponent c) {
        return new DockedWindowTabbedPaneUI();
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(60, 64);
    }

    protected void installDefaults() {
        UIManager.put("TabbedPane.tabsOpaque", Boolean.TRUE);
        super.installDefaults();
        this.tabInsets = new Insets(2, 2, 2, 2);
        this.contentBorderInsets = new Insets(1, 1, 4, 1);
        this.tabAreaInsets = new Insets(2, 4, 0, 4);
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        iconRect.y = 0;
        iconRect.x = 0;
        textRect.y = 0;
        textRect.x = 0;
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            this.tabPane.putClientProperty("html", v);
        }
        String croppedTitle = null;
        try {
            croppedTitle = SwingUtilities.layoutCompoundLabel(this.tabPane, metrics, title, icon, 0, 0, 0, 11, tabRect, iconRect, textRect, this.textIconGap);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            croppedTitle = "...";
        }
        int croppedCount = this.croppedTitlesList.size();
        int tabCount = this.tabPane.getTabCount();
        if (croppedCount < tabCount) {
            for (int i = croppedCount; i < tabCount; ++i) {
                this.croppedTitlesList.add("");
            }
        }
        this.croppedTitlesList.set(tabIndex, croppedTitle);
        this.tabPane.putClientProperty("html", null);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(DockableWindowUtil.getDockableWindowBorderColor());
        y = y + h - this.contentBorderInsets.bottom;
        g.drawLine(x, y, x + w - 1, y);
        g.setColor(UIManager.getColor("TabbedPane.highlight"));
        g.fillRect(x + 1, y + 1, w - 1, this.contentBorderInsets.bottom - 1);
        g.setColor(DockableWindowUtil.getDockableWindowBorderColor());
        y += this.contentBorderInsets.bottom - 1;
        if (selectedIndex < 0) {
            g.drawLine(x, y, x + w - 1, y);
        } else {
            Rectangle selRect = this.getTabBounds(selectedIndex, this.calcRect);
            int x2 = selRect.x - 2;
            if (selectedIndex == 0) {
                ++x2;
            }
            g.drawLine(x, y, x2, y);
            if (selRect.x + selRect.width < x + w - 2) {
                g.drawLine(selRect.x + selRect.width, y, x + w - 1, y);
            }
        }
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(DockableWindowUtil.getDockableWindowBorderColor());
        int y2 = y + h - 1;
        g.drawLine(x, y, x, y2);
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        g.setColor(DockableWindowUtil.getDockableWindowBorderColor());
        int y2 = y + h - 1;
        g.drawLine(x + w - 1, y, x + w - 1, y2);
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            Color c = UIManager.getColor("TabbedPane.highlight");
            if (SubstanceUtils.isSubstanceInstalled()) {
                try {
                    c = SubstanceUtils.getSubstanceColor("ExtraLightColor");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            g.setColor(c);
            g.fillRect(x, y, w, h);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            Paint old = g2d.getPaint();
            if (this.unselectedTabPaint == null) {
                if (SubstanceUtils.isSubstanceInstalled()) {
                    try {
                        this.unselectedTabPaint = SubstanceUtils.getSubstanceColor("UltraLightColor");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (this.unselectedTabPaint == null) {
                    this.unselectedTabPaint = new GradientPaint(0.0f, 0.0f, Color.LIGHT_GRAY, 0.0f, h / 2, UIManager.getColor("TabbedPane.highlight"));
                }
            }
            g2d.setPaint(this.unselectedTabPaint);
            AffineTransform trans = g2d.getTransform();
            g2d.translate(0, y);
            g2d.fillRect(x, 0, w, h);
            g2d.setTransform(trans);
            g2d.setPaint(old);
        }
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        int x2 = x + w - 1;
        g.setColor(DockableWindowUtil.getDockableWindowBorderColor());
        int y2 = y + h - 1;
        g.drawLine(x, y2, x2, y2);
        g.drawLine(x2, y2, x2, y);
        if (tabIndex == 0) {
            g.drawLine(x, y, x, y2);
        }
        if (!isSelected) {
            int selectedIndex = this.tabPane.getSelectedIndex();
            if (tabIndex == selectedIndex - 1) {
                g.drawLine(x2, y2, x2, y + this.maxTabHeight - 1);
            }
            g.setColor(UIManager.getColor("TabbedPane.highlight"));
            if (tabIndex < this.tabPane.getSelectedIndex()) {
                x = x2 - 1;
            } else if (tabIndex == 0) {
                ++x;
            }
            g.drawLine(x, y, x, y2 - 1);
        }
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        title = (String)this.croppedTitlesList.get(tabIndex);
        g.setFont(font);
        Color fg = this.tabPane.getForegroundAt(tabIndex);
        if (isSelected) {
            fg = UIManager.getColor("Label.foreground");
            if (fg == null && (fg = UIManager.getColor("textText")) == null) {
                fg = SystemColor.textText;
            }
        } else {
            fg = UIManager.getColor("Label.disabledForeground");
            if (fg == null && (fg = UIManager.getColor("textInactiveText")) == null) {
                fg = Color.GRAY;
            }
        }
        g.setColor(fg);
        g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
    }

    class PluginTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public PluginTabbedPaneLayout() {
            super(DockedWindowTabbedPaneUI.this);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            return DockedWindowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            return DockedWindowTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
        }

        public void layoutContainer(Container parent) {
            int tabPlacement = DockedWindowTabbedPaneUI.this.tabPane.getTabPlacement();
            Insets insets = DockedWindowTabbedPaneUI.this.tabPane.getInsets();
            int selectedIndex = DockedWindowTabbedPaneUI.this.tabPane.getSelectedIndex();
            Component visibleComponent = DockedWindowTabbedPaneUI.this.getVisibleComponent();
            this.calculateLayoutInfo();
            if (selectedIndex < 0) {
                if (visibleComponent != null) {
                    DockedWindowTabbedPaneUI.this.setVisibleComponent(null);
                }
            } else {
                Component selectedComponent = DockedWindowTabbedPaneUI.this.tabPane.getComponentAt(selectedIndex);
                if (selectedComponent != null) {
                    DockedWindowTabbedPaneUI.this.setVisibleComponent(selectedComponent);
                }
                Insets contentInsets = DockedWindowTabbedPaneUI.this.getContentBorderInsets(tabPlacement);
                Rectangle bounds = DockedWindowTabbedPaneUI.this.tabPane.getBounds();
                int numChildren = DockedWindowTabbedPaneUI.this.tabPane.getComponentCount();
                if (numChildren > 0) {
                    int th = DockedWindowTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, DockedWindowTabbedPaneUI.this.runCount, DockedWindowTabbedPaneUI.this.maxTabHeight);
                    int cx = insets.left + contentInsets.left;
                    int cy = insets.top + contentInsets.top;
                    int cw = bounds.width - insets.left - insets.right - contentInsets.left - contentInsets.right;
                    int ch = bounds.height - insets.top - insets.bottom - th - contentInsets.top - contentInsets.bottom;
                    for (int i = 0; i < numChildren; ++i) {
                        Component child = DockedWindowTabbedPaneUI.this.tabPane.getComponent(i);
                        child.setBounds(cx, cy, cw, ch);
                    }
                }
            }
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            FontMetrics metrics = DockedWindowTabbedPaneUI.this.getFontMetrics();
            int fontHeight = metrics.getHeight();
            Dimension size = DockedWindowTabbedPaneUI.this.tabPane.getSize();
            Insets insets = DockedWindowTabbedPaneUI.this.tabPane.getInsets();
            Insets tabAreaInsets = DockedWindowTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            boolean leftToRight = DockedWindowTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            DockedWindowTabbedPaneUI.this.maxTabHeight = DockedWindowTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            int x = tabAreaInsets.left;
            int y = size.height - insets.bottom - tabAreaInsets.bottom - DockedWindowTabbedPaneUI.this.maxTabHeight;
            DockedWindowTabbedPaneUI.this.runCount = 1;
            if (tabCount == 0) {
                return;
            }
            int tabAreaWidth = size.width - insets.left - insets.right - tabAreaInsets.left - tabAreaInsets.right;
            int allTabsPreferredWidth = 0;
            for (i = 0; i < tabCount; ++i) {
                allTabsPreferredWidth += DockedWindowTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
            }
            if (allTabsPreferredWidth <= tabAreaWidth) {
                for (i = 0; i < tabCount; ++i) {
                    rect = DockedWindowTabbedPaneUI.this.rects[i];
                    if (i > 0) {
                        rect.x = ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).rects[i - 1].x + ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).tabRuns[0] = 0;
                        DockedWindowTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = DockedWindowTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    DockedWindowTabbedPaneUI.this.maxTabWidth = Math.max(DockedWindowTabbedPaneUI.this.maxTabWidth, rect.width);
                    rect.y = y;
                    rect.height = DockedWindowTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                }
            } else {
                DockedWindowTabbedPaneUI.this.maxTabWidth = tabAreaWidth / tabCount;
                for (i = 0; i < tabCount; ++i) {
                    rect = DockedWindowTabbedPaneUI.this.rects[i];
                    rect.x = x + i * DockedWindowTabbedPaneUI.this.maxTabWidth;
                    rect.y = y;
                    rect.width = DockedWindowTabbedPaneUI.this.maxTabWidth;
                    rect.height = DockedWindowTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                }
            }
            if (!leftToRight) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (int i2 = 0; i2 < tabCount; ++i2) {
                    ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).rects[i2].x = rightMargin - ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).rects[i2].x - ((DockedWindowTabbedPaneUI)DockedWindowTabbedPaneUI.this).rects[i2].width;
                }
            }
        }
    }
}

