/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.borders;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import net.sf.tinylaf.Theme;
import net.sf.tinylaf.util.ColorRoutines;

public class TinyTableHeaderBorder
extends AbstractBorder
implements UIResource {
    protected static final Insets insetsXP = new Insets(3, 0, 3, 2);
    protected Color color1;
    protected Color color2;
    protected Color color3;
    protected Color color4;
    protected Color color5;

    public Insets getBorderInsets(Component c) {
        return insetsXP;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = TinyTableHeaderBorder.insetsXP.left;
        insets.top = TinyTableHeaderBorder.insetsXP.top;
        insets.right = TinyTableHeaderBorder.insetsXP.right;
        insets.bottom = TinyTableHeaderBorder.insetsXP.bottom;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (this.color1 == null) {
            this.color1 = ColorRoutines.darken(c.getBackground(), 5);
            this.color2 = ColorRoutines.darken(c.getBackground(), 10);
            this.color3 = ColorRoutines.darken(c.getBackground(), 15);
            this.color4 = Theme.tableHeaderDarkColor.getColor();
            this.color5 = Theme.tableHeaderLightColor.getColor();
        }
        g.setColor(this.color1);
        g.drawLine(x, y + h - 3, x + w - 1, y + h - 3);
        g.setColor(this.color2);
        g.drawLine(x, y + h - 2, x + w - 1, y + h - 2);
        g.setColor(this.color3);
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.setColor(this.color4);
        g.drawLine(x + w - 2, y + 3, x + w - 2, y + h - 5);
        g.setColor(this.color5);
        g.drawLine(x + w - 1, y + 3, x + w - 1, y + h - 5);
    }
}

