/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.util;

import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public abstract class PeriodicRunnable {
    private static final Logger logger = new LoggerImpl(PeriodicRunnable.class.getName());
    private final ScheduledExecutorService timer;
    private final ExecutorService executor;
    private final Object syncRoot = new Object();
    private volatile boolean running = false;
    private ScheduledFuture<?> scheduledSubmit;
    private Future<?> submittedExecute;

    protected PeriodicRunnable(ScheduledExecutorService timer, ExecutorService executor) {
        if (timer == null) {
            throw new IllegalArgumentException("timer is null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor is null");
        }
        this.timer = timer;
        this.executor = executor;
    }

    protected abstract Duration getDelayUntilNextRun();

    protected abstract void run();

    public void schedule() {
        if (this.running) {
            return;
        }
        Duration delay = this.getDelayUntilNextRun();
        this.scheduleNextRun(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (!this.running) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (this.running) {
                this.running = false;
                if (this.scheduledSubmit != null) {
                    this.scheduledSubmit.cancel(true);
                    this.scheduledSubmit = null;
                }
                if (this.submittedExecute != null) {
                    this.submittedExecute.cancel(true);
                    this.submittedExecute = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleNextRun(Duration delay) {
        Object object = this.syncRoot;
        synchronized (object) {
            boolean isRecurrentRun;
            boolean bl = isRecurrentRun = this.submittedExecute != null;
            if (isRecurrentRun && !this.running) {
                return;
            }
            if (delay.isNegative()) {
                this.running = false;
                this.scheduledSubmit = null;
                this.submittedExecute = null;
                return;
            }
            this.running = true;
            if (delay.isZero()) {
                this.submitExecuteRun();
            } else {
                this.scheduledSubmit = this.timer.schedule(this::submitExecuteRun, delay.toNanos(), TimeUnit.NANOSECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitExecuteRun() {
        if (!this.running) {
            return;
        }
        Object object = this.syncRoot;
        synchronized (object) {
            if (!this.running) {
                return;
            }
            this.submittedExecute = this.executor.submit(this::executeRun);
        }
    }

    private void executeRun() {
        if (!this.running) {
            return;
        }
        try {
            this.run();
        }
        catch (Exception e) {
            logger.warn("Exception in run(), will retry.", e);
        }
        finally {
            if (this.running) {
                Duration delayMillis = this.getDelayUntilNextRun();
                this.scheduleNextRun(delayMillis);
            }
        }
    }

    static PeriodicRunnable create(ScheduledExecutorService timer, ExecutorService executor, final Duration period, final Runnable r) {
        return new PeriodicRunnable(timer, executor){

            @Override
            protected Duration getDelayUntilNextRun() {
                return period;
            }

            @Override
            protected void run() {
                r.run();
            }
        };
    }
}

