/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.bandwidthestimation2.BandwidthUsage;
import org.jitsi.nlj.rtp.bandwidthestimation2.BweDefinesKt;
import org.jitsi.nlj.rtp.bandwidthestimation2.LinkCapacityEstimator;
import org.jitsi.nlj.rtp.bandwidthestimation2.RateControlInput;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.nlj.util.DataSize;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.InstantKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u0000 V2\u00020\u0001:\u0002UVB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0007\u00a2\u0006\u0004\b-\u0010.J\u0015\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u0007\u00a2\u0006\u0004\b1\u0010.J\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u00020#J\u001d\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00162\u0006\u00106\u001a\u00020\u0007\u00a2\u0006\u0004\b7\u00108J\u000e\u00109\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0016J\r\u0010:\u001a\u00020\u0007\u00a2\u0006\u0004\b;\u0010<J\u001d\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u00020\u0016\u00a2\u0006\u0004\b@\u0010AJ\u001d\u0010B\u001a\u00020+2\u0006\u0010C\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0016\u00a2\u0006\u0004\bD\u0010EJ\u0006\u0010F\u001a\u00020\u001dJ\u0006\u0010G\u001a\u00020#J\u0018\u0010H\u001a\u00020+2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u00020\u0016H\u0002J\u0017\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bK\u0010LJ'\u0010M\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00162\u0006\u0010N\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\bO\u0010PJ\u001f\u0010Q\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u00162\u0006\u0010N\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\bR\u0010SJ\u0018\u0010T\u001a\u00020+2\u0006\u0010>\u001a\u00020?2\u0006\u00105\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0010\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\u00020\u00168\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006W"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl;", "", "sendSide", "", "<init>", "(Z)V", "minConfiguredBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "J", "maxConfiguredBitrate", "currentBitrate", "latestEstimatedThroughput", "linkCapacity", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/LinkCapacityEstimator;", "getLinkCapacity", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/LinkCapacityEstimator;", "value", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;", "rateControlState", "getRateControlState", "()Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;", "timeLastBitrateChange", "Ljava/time/Instant;", "timeLastBitrateDecrease", "getTimeLastBitrateDecrease$annotations", "()V", "timeFirstThroughputEstimate", "bitrateIsInitialized", "beta", "", "inAlr", "getInAlr", "()Z", "setInAlr", "rtt", "Ljava/time/Duration;", "getRtt", "()Ljava/time/Duration;", "setRtt", "(Ljava/time/Duration;)V", "noBitrateIncreaseInAlr", "lastDecrease", "setStartBitrate", "", "startBitrate", "setStartBitrate-_2icLw0", "(J)V", "setMinBitrate", "minBitrate", "setMinBitrate-_2icLw0", "validEstimate", "getFeedbackInterval", "timeToReduceFurther", "atTime", "estimatedThroughput", "timeToReduceFurther-ERFH51c", "(Ljava/time/Instant;J)Z", "initialTimeToReduceFurther", "latestEstimate", "latestEstimate-rlWvAKk", "()J", "update", "input", "Lorg/jitsi/nlj/rtp/bandwidthestimation2/RateControlInput;", "update-MxRVi0s", "(Lorg/jitsi/nlj/rtp/bandwidthestimation2/RateControlInput;Ljava/time/Instant;)J", "setEstimate", "bitrate", "setEstimate-SimD6oM", "(JLjava/time/Instant;)V", "getNearMaxIncreaseRateBpsPerSecond", "getExpectedBandwidthPeriod", "changeBitrate", "clampBitrate", "newBitrate", "clampBitrate-GI7mN98", "(J)J", "multiplicativeRateIncrease", "lastTime", "multiplicativeRateIncrease-V-PpFzc", "(Ljava/time/Instant;Ljava/time/Instant;J)J", "additiveRateIncrease", "additiveRateIncrease-MxRVi0s", "(Ljava/time/Instant;Ljava/time/Instant;)J", "changeState", "RateControlState", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAimdRateControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AimdRateControl.kt\norg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,361:1\n1#2:362\n*E\n"})
public final class AimdRateControl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean sendSide;
    private long minConfiguredBitrate;
    private long maxConfiguredBitrate;
    private long currentBitrate;
    private long latestEstimatedThroughput;
    @NotNull
    private final LinkCapacityEstimator linkCapacity;
    @NotNull
    private RateControlState rateControlState;
    @NotNull
    private Instant timeLastBitrateChange;
    @NotNull
    private Instant timeLastBitrateDecrease;
    @NotNull
    private Instant timeFirstThroughputEstimate;
    private boolean bitrateIsInitialized;
    private double beta;
    private boolean inAlr;
    @NotNull
    private Duration rtt;
    private final boolean noBitrateIncreaseInAlr;
    @Nullable
    private Bandwidth lastDecrease;
    @NotNull
    private static final Duration kDefaultRtt = DurationKt.getMs(200);
    private static final double kDefaultBackoffFactor = 0.85;

    public AimdRateControl(boolean sendSide) {
        this.sendSide = sendSide;
        this.minConfiguredBitrate = BweDefinesKt.getKCongestionControllerMinBitrate();
        this.latestEstimatedThroughput = this.currentBitrate = (this.maxConfiguredBitrate = BandwidthKt.getKbps(30000));
        this.linkCapacity = new LinkCapacityEstimator();
        this.rateControlState = RateControlState.kRcHold;
        this.timeLastBitrateChange = InstantKt.NEVER;
        this.timeLastBitrateDecrease = InstantKt.NEVER;
        this.timeFirstThroughputEstimate = InstantKt.NEVER;
        this.beta = 0.85;
        this.rtt = kDefaultRtt;
    }

    public /* synthetic */ AimdRateControl(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final LinkCapacityEstimator getLinkCapacity() {
        return this.linkCapacity;
    }

    @NotNull
    public final RateControlState getRateControlState() {
        return this.rateControlState;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private static /* synthetic */ void getTimeLastBitrateDecrease$annotations() {
    }

    public final boolean getInAlr() {
        return this.inAlr;
    }

    public final void setInAlr(boolean bl) {
        this.inAlr = bl;
    }

    @NotNull
    public final Duration getRtt() {
        return this.rtt;
    }

    public final void setRtt(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter(duration, "<set-?>");
        this.rtt = duration;
    }

    public final void setStartBitrate-_2icLw0(long startBitrate) {
        this.currentBitrate = startBitrate;
        this.latestEstimatedThroughput = startBitrate;
        this.bitrateIsInitialized = true;
    }

    public final void setMinBitrate-_2icLw0(long minBitrate) {
        this.minConfiguredBitrate = minBitrate;
        this.currentBitrate = BandwidthKt.max-YUm52VA(minBitrate, this.currentBitrate);
    }

    public final boolean validEstimate() {
        return this.bitrateIsInitialized;
    }

    @NotNull
    public final Duration getFeedbackInterval() {
        DataSize kRtcpSize = DataSizeKt.getBytes(80);
        long rtcpBitrate = Bandwidth.times-WElJv5I(this.currentBitrate, 0.05);
        Duration interval2 = BandwidthKt.div-ERFH51c(kRtcpSize, rtcpBitrate);
        Duration kMinFeedbackInterval = DurationKt.getMs(200);
        Duration kMaxFeedbackInterval = DurationKt.getMs(1000);
        return DurationKt.coerceIn(interval2, kMinFeedbackInterval, kMaxFeedbackInterval);
    }

    public final boolean timeToReduceFurther-ERFH51c(@NotNull Instant atTime, long estimatedThroughput) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        Duration bitrateReductionInterval = DurationKt.coerceIn(this.rtt, DurationKt.getMs(10), DurationKt.getMs(200));
        if (Duration.between(this.timeLastBitrateChange, atTime).compareTo(bitrateReductionInterval) >= 0) {
            return true;
        }
        if (this.validEstimate()) {
            long threshold = BandwidthKt.times-ERFH51c(0.5, this.latestEstimate-rlWvAKk());
            return Bandwidth.compareTo-_2icLw0(estimatedThroughput, threshold) < 0;
        }
        return false;
    }

    public final boolean initialTimeToReduceFurther(@NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        return this.validEstimate() && this.timeToReduceFurther-ERFH51c(atTime, Bandwidth.minus-GI7mN98(Bandwidth.div-WElJv5I(this.latestEstimate-rlWvAKk(), 2), BandwidthKt.getBps(1)));
    }

    public final long latestEstimate-rlWvAKk() {
        return this.currentBitrate;
    }

    public final long update-MxRVi0s(@NotNull RateControlInput input, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        if (!this.bitrateIsInitialized) {
            Duration kInitializionTime = DurationKt.getSecs(5);
            if (!(BweDefinesKt.getKBitrateWindow().compareTo(kInitializionTime) <= 0)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            if (Intrinsics.areEqual(this.timeFirstThroughputEstimate, InstantKt.NEVER)) {
                if (input.getEstimatedThroughput-4yB3KFE() != null) {
                    this.timeFirstThroughputEstimate = atTime;
                }
            } else if (Duration.between(this.timeFirstThroughputEstimate, atTime).compareTo(kInitializionTime) > 0) {
                Bandwidth bandwidth = input.getEstimatedThroughput-4yB3KFE();
                if (bandwidth != null) {
                    long it = bandwidth.unbox-impl();
                    boolean bl = false;
                    this.currentBitrate = it;
                    this.bitrateIsInitialized = true;
                }
            }
        }
        this.changeBitrate(input, atTime);
        return this.currentBitrate;
    }

    public final void setEstimate-SimD6oM(long bitrate, @NotNull Instant atTime) {
        Intrinsics.checkNotNullParameter(atTime, "atTime");
        this.bitrateIsInitialized = true;
        long prevBitrate = this.currentBitrate;
        this.currentBitrate = this.clampBitrate-GI7mN98(bitrate);
        this.timeLastBitrateChange = atTime;
        if (Bandwidth.compareTo-_2icLw0(this.currentBitrate, prevBitrate) < 0) {
            this.timeLastBitrateDecrease = atTime;
        }
    }

    public final double getNearMaxIncreaseRateBpsPerSecond() {
        Duration responseTime;
        if (!(!Bandwidth.equals-impl0(this.currentBitrate, BandwidthKt.getBps(0)))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        Duration kFrameInterval = DurationKt.div(DurationKt.getSecs(1), 30.0);
        DataSize frameSize = BandwidthKt.times-SimD6oM(this.currentBitrate, kFrameInterval).toWholeBytes();
        DataSize kPacketSize = DataSizeKt.getBytes(1200);
        double packetsPerFrame = Math.ceil(frameSize.div(kPacketSize));
        DataSize avgPacketSize = frameSize.div(packetsPerFrame).toWholeBytes();
        Duration duration = responseTime = this.rtt.plus(DurationKt.getMs(100));
        Intrinsics.checkNotNull(duration);
        responseTime = DurationKt.times(duration, 2);
        double increaseRateBpsPerSecond = BandwidthKt.per(avgPacketSize, responseTime);
        double kMinIncreaseRateBpsPerSecond = 4000.0;
        return RangesKt.coerceAtLeast(increaseRateBpsPerSecond, kMinIncreaseRateBpsPerSecond);
    }

    @NotNull
    public final Duration getExpectedBandwidthPeriod() {
        Duration kMinPeriod = DurationKt.getSecs(2);
        Duration kDefaultPeriod = DurationKt.getSecs(3);
        Duration kMaxPeriod = DurationKt.getSecs(50);
        double increaseRateBpsPerSecond = this.getNearMaxIncreaseRateBpsPerSecond();
        if (this.lastDecrease == null) {
            return kDefaultPeriod;
        }
        Bandwidth bandwidth = this.lastDecrease;
        Intrinsics.checkNotNull(bandwidth);
        double timeToRecoverDecreaseSeconds = (double)bandwidth.unbox-impl() / increaseRateBpsPerSecond;
        Duration period = DurationKt.durationOfDoubleSeconds(timeToRecoverDecreaseSeconds);
        return DurationKt.coerceIn(period, kMinPeriod, kMaxPeriod);
    }

    private final void changeBitrate(RateControlInput input, Instant atTime) {
        Bandwidth newBitrate = null;
        Bandwidth bandwidth = input.getEstimatedThroughput-4yB3KFE();
        long estimatedThroughput = bandwidth != null ? bandwidth.unbox-impl() : this.latestEstimatedThroughput;
        Bandwidth bandwidth2 = input.getEstimatedThroughput-4yB3KFE();
        if (bandwidth2 != null) {
            long it = bandwidth2.unbox-impl();
            boolean bl = false;
            this.latestEstimatedThroughput = it;
        }
        if (!this.bitrateIsInitialized && input.getBwState() != BandwidthUsage.kBwOverusing) {
            return;
        }
        this.changeState(input, atTime);
        switch (WhenMappings.$EnumSwitchMapping$0[this.rateControlState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                if (Bandwidth.compareTo-_2icLw0(estimatedThroughput, this.linkCapacity.upperBound-rlWvAKk()) > 0) {
                    this.linkCapacity.reset();
                }
                long increaseLimit = Bandwidth.plus-GI7mN98(BandwidthKt.times-ERFH51c(1.5, estimatedThroughput), BandwidthKt.getKbps(10));
                if (this.sendSide && this.inAlr && this.noBitrateIncreaseInAlr) {
                    increaseLimit = this.currentBitrate;
                }
                if (Bandwidth.compareTo-_2icLw0(this.currentBitrate, increaseLimit) < 0) {
                    long increasedBitrate = Bandwidth.Companion.getMINUS_INFINITY-rlWvAKk();
                    if (this.linkCapacity.hasEstimate()) {
                        long additiveIncrease = this.additiveRateIncrease-MxRVi0s(atTime, this.timeLastBitrateChange);
                        increasedBitrate = Bandwidth.plus-GI7mN98(this.currentBitrate, additiveIncrease);
                    } else {
                        long multiplicativeIncrease = this.multiplicativeRateIncrease-V-PpFzc(atTime, this.timeLastBitrateChange, this.currentBitrate);
                        increasedBitrate = Bandwidth.plus-GI7mN98(this.currentBitrate, multiplicativeIncrease);
                    }
                    newBitrate = RangesKt.coerceAtMost(Bandwidth.box-impl(increasedBitrate), Bandwidth.box-impl(increaseLimit));
                }
                this.timeLastBitrateChange = atTime;
                break;
            }
            case 3: {
                long decreasedBitrate = Bandwidth.Companion.getINFINITY-rlWvAKk();
                decreasedBitrate = Bandwidth.times-WElJv5I(estimatedThroughput, this.beta);
                if (Bandwidth.compareTo-_2icLw0(decreasedBitrate, BandwidthKt.getKbps(5)) > 0) {
                    decreasedBitrate = Bandwidth.minus-GI7mN98(decreasedBitrate, BandwidthKt.getKbps(5));
                }
                if (Bandwidth.compareTo-_2icLw0(decreasedBitrate, this.currentBitrate) > 0 && this.linkCapacity.hasEstimate()) {
                    Bandwidth bandwidth3 = this.linkCapacity.getEstimate-4yB3KFE();
                    Intrinsics.checkNotNull(bandwidth3);
                    decreasedBitrate = Bandwidth.times-WElJv5I(bandwidth3.unbox-impl(), this.beta);
                }
                if (Bandwidth.compareTo-_2icLw0(decreasedBitrate, this.currentBitrate) < 0) {
                    newBitrate = Bandwidth.box-impl(decreasedBitrate);
                }
                if (this.bitrateIsInitialized && Bandwidth.compareTo-_2icLw0(estimatedThroughput, this.currentBitrate) < 0) {
                    this.lastDecrease = newBitrate == null ? Bandwidth.box-impl(Bandwidth.Companion.getZERO-rlWvAKk()) : Bandwidth.box-impl(Bandwidth.minus-GI7mN98(this.currentBitrate, newBitrate.unbox-impl()));
                }
                if (Bandwidth.compareTo-_2icLw0(estimatedThroughput, this.linkCapacity.lowerBound-rlWvAKk()) < 0) {
                    this.linkCapacity.reset();
                }
                this.bitrateIsInitialized = true;
                this.linkCapacity.onOveruseDetected-_2icLw0(estimatedThroughput);
                this.rateControlState = RateControlState.kRcHold;
                this.timeLastBitrateChange = atTime;
                this.timeLastBitrateDecrease = atTime;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Bandwidth bandwidth4 = newBitrate;
        this.currentBitrate = this.clampBitrate-GI7mN98(bandwidth4 != null ? bandwidth4.unbox-impl() : this.currentBitrate);
    }

    private final long clampBitrate-GI7mN98(long newBitrate) {
        return RangesKt.coerceAtLeast(Bandwidth.box-impl(newBitrate), Bandwidth.box-impl(this.minConfiguredBitrate)).unbox-impl();
    }

    private final long multiplicativeRateIncrease-V-PpFzc(Instant atTime, Instant lastTime, long currentBitrate) {
        double alpha = 1.08;
        if (!Intrinsics.areEqual(lastTime, InstantKt.NEVER)) {
            Duration timeSinceLastUpdate = Duration.between(lastTime, atTime);
            Intrinsics.checkNotNull(timeSinceLastUpdate);
            alpha = Math.pow(alpha, Math.min(DurationKt.toDouble(timeSinceLastUpdate), 1.0));
        }
        long multiplicativeIncrease = BandwidthKt.max-YUm52VA(Bandwidth.times-WElJv5I(currentBitrate, alpha - 1.0), BandwidthKt.getBps(1000));
        return multiplicativeIncrease;
    }

    private final long additiveRateIncrease-MxRVi0s(Instant atTime, Instant lastTime) {
        Duration duration = Duration.between(lastTime, atTime);
        Intrinsics.checkNotNullExpressionValue(duration, "between(...)");
        double timePeriodSeconds = DurationKt.toDouble(duration);
        double dataRateIncreaseBps = this.getNearMaxIncreaseRateBpsPerSecond() * timePeriodSeconds;
        return BandwidthKt.getBps(dataRateIncreaseBps);
    }

    private final void changeState(RateControlInput input, Instant atTime) {
        switch (WhenMappings.$EnumSwitchMapping$1[input.getBwState().ordinal()]) {
            case 1: {
                if (this.rateControlState != RateControlState.kRcHold) break;
                this.timeLastBitrateChange = atTime;
                this.rateControlState = RateControlState.kRcIncrease;
                break;
            }
            case 2: {
                if (this.rateControlState == RateControlState.kRcDecrease) break;
                this.rateControlState = RateControlState.kRcDecrease;
                break;
            }
            case 3: {
                this.rateControlState = RateControlState.kRcHold;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public AimdRateControl() {
        this(false, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$Companion;", "", "<init>", "()V", "kDefaultRtt", "Ljava/time/Duration;", "kDefaultBackoffFactor", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/AimdRateControl$RateControlState;", "", "<init>", "(Ljava/lang/String;I)V", "kRcHold", "kRcIncrease", "kRcDecrease", "jitsi-media-transform"})
    public static final class RateControlState
    extends Enum<RateControlState> {
        public static final /* enum */ RateControlState kRcHold = new RateControlState();
        public static final /* enum */ RateControlState kRcIncrease = new RateControlState();
        public static final /* enum */ RateControlState kRcDecrease = new RateControlState();
        private static final /* synthetic */ RateControlState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RateControlState[] values() {
            return (RateControlState[])$VALUES.clone();
        }

        public static RateControlState valueOf(String value2) {
            return Enum.valueOf(RateControlState.class, value2);
        }

        @NotNull
        public static EnumEntries<RateControlState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = rateControlStateArray = new RateControlState[]{RateControlState.kRcHold, RateControlState.kRcIncrease, RateControlState.kRcDecrease};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RateControlState.values().length];
            try {
                nArray[RateControlState.kRcHold.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RateControlState.kRcIncrease.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RateControlState.kRcDecrease.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BandwidthUsage.values().length];
            try {
                nArray[BandwidthUsage.kBwNormal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthUsage.kBwOverusing.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BandwidthUsage.kBwUnderusing.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

