/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.activity;

import java.util.Iterator;
import uk.ac.ic.doc.scenebeans.activity.Activity;

public abstract class ActivityList {
    public static final ActivityList EMPTY = new EmptyActivityList();

    private ActivityList() {
    }

    public abstract void performActivities(double var1);

    public final ActivityList add(Activity activity) {
        return new Node(activity, this);
    }

    public abstract ActivityList remove(Activity var1);

    public Iterator iterator() {
        return new Iterator(this){
            private ActivityList _current;
            private final /* synthetic */ ActivityList this$0;
            {
                this._current = this.this$0 = activityList;
            }

            public boolean hasNext() {
                return this._current != EMPTY;
            }

            public Object next() {
                Activity activity = ((Node)this._current)._element;
                this._current = ((Node)this._current)._next;
                return activity;
            }

            public void remove() {
                throw new UnsupportedOperationException("attempt to remove an elements from an ActivityList");
            }
        };
    }

    static class Node
    extends ActivityList {
        private Activity _element;
        private ActivityList _next;

        Node(Activity activity, ActivityList activityList) {
            this._element = activity;
            this._next = activityList;
        }

        Node(Activity activity) {
            this._element = activity;
            this._next = EMPTY;
        }

        public void performActivities(double d) {
            this._element.performActivity(d);
            this._next.performActivities(d);
        }

        public ActivityList remove(Activity activity) {
            if (this._element == activity) {
                return this._next;
            }
            ActivityList activityList = this._next.remove(activity);
            if (activityList == this._next) {
                return this;
            }
            return new Node(this._element, activityList);
        }
    }

    private static class EmptyActivityList
    extends ActivityList {
        private EmptyActivityList() {
        }

        public ActivityList remove(Activity activity) {
            return this;
        }

        public void performActivities(double d) {
        }
    }
}

