/**
 * This module operates on the view states from the message_drawer_view_conversation module.
 * It exposes functions that can be used to generate new version of the state.
 *
 * Important notes for this module:
 * 1.) The existing state is always immutable. It should never be modified.
 * 2.) All functions that operate on the state should always clone the state and
 *     modify the cloned state before returning it.
 *
 * It's important that the states remain immutable because they are diff'd in
 * the message_drawer_view_conversation_patcher module in order to work out what
 * has changed.
 *
 * @module     core_message/message_drawer_view_conversation_state_manager
 * @copyright  2018 Ryan Wyllie <ryan@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("core_message/message_drawer_view_conversation_state_manager",["jquery"],(function($){var cloneState=function(state){return $.extend(!0,{},state)},formatMessages=function(messages,loggedInUserId,members){return messages.map((function(message){var fromLoggedInUser=message.useridfrom==loggedInUserId;return{id:""+message.id,fromLoggedInUser:fromLoggedInUser,userFrom:members[message.useridfrom],text:message.text,timeCreated:message.timecreated?parseInt(message.timecreated,10):null}}))};return{buildInitialState:function(midnight,loggedInUserId,id,messagePollMin,messagePollMax,messagePollAfterMax){return{midnight:midnight,loggedInUserId:loggedInUserId,id:id,messagePollMin:messagePollMin,messagePollMax:messagePollMax,messagePollAfterMax:messagePollAfterMax,name:null,subname:null,type:null,totalMemberCount:null,imageUrl:null,isFavourite:null,isMuted:null,canDeleteMessagesForAllUsers:!1,deleteMessagesForAllUsers:!1,members:{},messages:[],hasTriedToLoadMessages:!1,loadingMessages:!0,loadingMembers:!0,loadingConfirmAction:!1,pendingBlockUserIds:[],pendingUnblockUserIds:[],pendingRemoveContactIds:[],pendingAddContactIds:[],pendingDeleteMessageIds:[],pendingSendMessageIds:[],pendingDeleteConversation:!1,selectedMessageIds:[],showEmojiAutoComplete:!1,showEmojiPicker:!1}},addMessages:function(state,messages){var newState=cloneState(state),formattedMessages=formatMessages(messages,state.loggedInUserId,state.members);formattedMessages=formattedMessages.map((function(message){return message.sendState=null,message.timeAdded=Date.now(),message.errorMessage=null,message}));var allMessages=state.messages.concat(formattedMessages);return allMessages.sort((function(a,b){if(null===a.timeCreated&&null===b.timeCreated){if(a.timeAdded<b.timeAdded)return-1;if(a.timeAdded>b.timeAdded)return 1}return null===a.timeCreated&&null!==b.timeCreated?1:null!==a.timeCreated&&null===b.timeCreated||a.timeCreated<b.timeCreated?-1:a.timeCreated>b.timeCreated?1:a.id<b.id?-1:a.id>b.id?1:0})),newState.messages=allMessages.filter((function(message,index,sortedMessages){return!index||message.id!=sortedMessages[index-1].id})),newState},updateMessages:function(state,data){var newState=cloneState(state),updatesById=data.reduce((function(carry,messageData){var oldMessage=messageData[0],newMessage=messageData[1],formattedMessage=formatMessages([newMessage],state.loggedInUserId,state.members)[0];return carry[oldMessage.id]=formattedMessage,carry}),{});return newState.messages=newState.messages.map((function(message){return message.id in updatesById?$.extend(message,updatesById[message.id]):message})),newState},removeMessages:function(state,messages){var newState=cloneState(state),removeMessageIds=messages.map((function(message){return""+message.id}));return newState.messages=newState.messages.filter((function(message){return removeMessageIds.indexOf(message.id)<0})),newState},removeMessagesById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.messages=newState.messages.filter((function(message){return messageIds.indexOf(message.id)<0})),newState},addMembers:function(state,members){var newState=cloneState(state),formattedMembers=function(members){return members.map((function(member){return{id:member.id,fullname:member.fullname,profileurl:member.profileurl,profileimageurl:member.profileimageurl,profileimageurlsmall:member.profileimageurlsmall,isonline:member.isonline,showonlinestatus:member.showonlinestatus,isblocked:member.isblocked,iscontact:member.iscontact,isdeleted:member.isdeleted,canmessage:member.canmessage,canmessageevenifblocked:member.canmessageevenifblocked,requirescontact:member.requirescontact,contactrequests:member.contactrequests||[]}}))}(members);return formattedMembers.forEach((function(member){newState.members[member.id]=member})),newState},removeMembers:function(state,members){var newState=cloneState(state);return members.forEach((function(member){delete newState.members[member.id]})),newState},setLoadingMessages:function(state,value){var newState=cloneState(state);return newState.loadingMessages=value,state.loadingMessages&&!value&&(newState.hasTriedToLoadMessages=!0),newState},setLoadingMembers:function(state,value){var newState=cloneState(state);return newState.loadingMembers=value,newState},setId:function(state,value){var newState=cloneState(state);return newState.id=value,newState},setName:function(state,value){var newState=cloneState(state);return newState.name=value,newState},setSubname:function(state,value){var newState=cloneState(state);return newState.subname=value,newState},setType:function(state,type){var newState=cloneState(state);return newState.type=type,newState},setIsFavourite:function(state,isFavourite){var newState=cloneState(state);return newState.isFavourite=isFavourite,newState},setIsMuted:function(state,isMuted){var newState=cloneState(state);return newState.isMuted=isMuted,newState},setCanDeleteMessagesForAllUsers:function(state,value){var newState=cloneState(state);return newState.canDeleteMessagesForAllUsers=value,newState},setDeleteMessagesForAllUsers:function(state,value){var newState=cloneState(state);return newState.deleteMessagesForAllUsers=value,newState},setTotalMemberCount:function(state,count){var newState=cloneState(state);return newState.totalMemberCount=count,newState},setImageUrl:function(state,url){var newState=cloneState(state);return newState.imageUrl=url,newState},setLoadingConfirmAction:function(state,value){var newState=cloneState(state);return newState.loadingConfirmAction=value,newState},setPendingDeleteConversation:function(state,value){var newState=cloneState(state);return newState.pendingDeleteConversation=value,newState},setMessagesSendPendingById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.messages.forEach((function(message){messageIds.indexOf(message.id)>=0&&(message.sendState="pending",message.errorMessage=null)})),newState},setMessagesSendSuccessById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.messages.forEach((function(message){messageIds.indexOf(message.id)>=0&&(message.sendState="sent",message.errorMessage=null)})),newState},setMessagesSendFailById:function(state,messageIds,errorMessage){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.messages.forEach((function(message){messageIds.indexOf(message.id)>=0&&(message.sendState="error",message.errorMessage=errorMessage)})),newState},setShowEmojiAutoComplete:function(state,show){var newState=cloneState(state);return newState.showEmojiAutoComplete=show,newState},setShowEmojiPicker:function(state,show){var newState=cloneState(state);return newState.showEmojiPicker=show,newState},addPendingBlockUsersById:function(state,userIds){var newState=cloneState(state);return userIds.forEach((function(id){newState.pendingBlockUserIds.push(id)})),newState},addPendingRemoveContactsById:function(state,userIds){var newState=cloneState(state);return userIds.forEach((function(id){newState.pendingRemoveContactIds.push(id)})),newState},addPendingUnblockUsersById:function(state,userIds){var newState=cloneState(state);return userIds.forEach((function(id){newState.pendingUnblockUserIds.push(id)})),newState},addPendingAddContactsById:function(state,userIds){var newState=cloneState(state);return userIds.forEach((function(id){newState.pendingAddContactIds.push(id)})),newState},addPendingDeleteMessagesById:function(state,messageIds){var newState=cloneState(state);return messageIds.forEach((function(id){newState.pendingDeleteMessageIds.push(id)})),newState},removePendingBlockUsersById:function(state,userIds){var newState=cloneState(state);return newState.pendingBlockUserIds=newState.pendingBlockUserIds.filter((function(id){return userIds.indexOf(id)<0})),newState},removePendingRemoveContactsById:function(state,userIds){var newState=cloneState(state);return newState.pendingRemoveContactIds=newState.pendingRemoveContactIds.filter((function(id){return userIds.indexOf(id)<0})),newState},removePendingUnblockUsersById:function(state,userIds){var newState=cloneState(state);return newState.pendingUnblockUserIds=newState.pendingUnblockUserIds.filter((function(id){return userIds.indexOf(id)<0})),newState},removePendingAddContactsById:function(state,userIds){var newState=cloneState(state);return newState.pendingAddContactIds=newState.pendingAddContactIds.filter((function(id){return userIds.indexOf(id)<0})),newState},removePendingDeleteMessagesById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.pendingDeleteMessageIds=newState.pendingDeleteMessageIds.filter((function(id){return messageIds.indexOf(id)<0})),newState},addSelectedMessagesById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.selectedMessageIds=newState.selectedMessageIds.concat(messageIds),newState},removeSelectedMessagesById:function(state,messageIds){var newState=cloneState(state);return messageIds=messageIds.map((function(id){return""+id})),newState.selectedMessageIds=newState.selectedMessageIds.filter((function(id){return messageIds.indexOf(id)<0})),newState},markMessagesAsRead:function(state,readMessages){var newState=cloneState(state),readMessageIds=readMessages.map((function(message){return message.id}));return newState.messages=newState.messages.map((function(message){return readMessageIds.indexOf(message.id)>=0&&(message.isRead=!0),message})),newState},addContactRequests:function(state,requests){var newState=cloneState(state);return requests.forEach((function(request){var fromUserId=request.userid,toUserId=request.requesteduserid;newState.members[fromUserId].contactrequests.push(request),newState.members[toUserId].contactrequests.push(request)})),newState},removeContactRequests:function(state,requests){var newState=cloneState(state);return requests.forEach((function(request){var fromUserId=request.userid,toUserId=request.requesteduserid;newState.members[fromUserId].contactrequests=newState.members[fromUserId].contactrequests.filter((function(existing){return existing.userid!=fromUserId})),newState.members[toUserId].contactrequests=newState.members[toUserId].contactrequests.filter((function(existing){return existing.requesteduserid!=toUserId}))})),newState}}}));

//# sourceMappingURL=message_drawer_view_conversation_state_manager.min.js.map