/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BasicTextUI
extends TextUI
implements ViewFactory {
    static EditorKit kit = new DefaultEditorKit();
    RootView rootView;
    JTextComponent textComponent;
    PropertyChangeHandler updateHandler;
    DocumentHandler documentHandler;
    Color background;
    Color inactiveBackground;
    private FocusListener focuslistener;

    protected Caret createCaret() {
        return new BasicCaret();
    }

    protected Highlighter createHighlighter() {
        return new BasicHighlighter();
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
        this.textComponent = (JTextComponent)c;
        Document doc = this.textComponent.getDocument();
        if (doc == null) {
            doc = this.getEditorKit(this.textComponent).createDefaultDocument();
            this.textComponent.setDocument(doc);
        }
        this.textComponent.addPropertyChangeListener(this.updateHandler);
        this.modelChanged();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        Highlighter highlighter;
        Caret caret = this.textComponent.getCaret();
        if (caret == null) {
            caret = this.createCaret();
            this.textComponent.setCaret(caret);
        }
        if ((highlighter = this.textComponent.getHighlighter()) == null) {
            this.textComponent.setHighlighter(this.createHighlighter());
        }
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installColorsAndFont(this.textComponent, prefix + ".background", prefix + ".foreground", prefix + ".font");
        LookAndFeel.installBorder(this.textComponent, prefix + ".border");
        this.textComponent.setMargin(UIManager.getInsets(prefix + ".margin"));
        caret.setBlinkRate(UIManager.getInt(prefix + ".caretBlinkRate"));
        this.inactiveBackground = UIManager.getColor(prefix + ".inactiveBackground");
        this.textComponent.setDisabledTextColor(UIManager.getColor(prefix + ".inactiveForeground"));
        this.textComponent.setSelectedTextColor(UIManager.getColor(prefix + ".selectionForeground"));
    }

    protected void installListeners() {
        this.textComponent.addFocusListener(this.focuslistener);
        this.installDocumentListeners();
    }

    private final void installDocumentListeners() {
        Document doc = this.textComponent.getDocument();
        if (doc != null) {
            doc.addDocumentListener(this.documentHandler);
        }
    }

    protected String getKeymapName() {
        String fullClassName = this.getClass().getName();
        int index = fullClassName.lastIndexOf(46);
        String className = fullClassName.substring(index + 1);
        return className;
    }

    protected Keymap createKeymap() {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        JTextComponent.KeyBinding[] bindings = (JTextComponent.KeyBinding[])defaults.get(prefix + ".keyBindings");
        if (bindings == null) {
            bindings = new JTextComponent.KeyBinding[]{};
            defaults.put(prefix + ".keyBindings", bindings);
        }
        Keymap km = JTextComponent.addKeymap(this.getKeymapName(), JTextComponent.getKeymap("default"));
        JTextComponent.loadKeymap(km, bindings, this.textComponent.getActions());
        return km;
    }

    protected void installKeyboardActions() {
        Keymap km = JTextComponent.getKeymap(this.getKeymapName());
        if (km == null) {
            km = this.createKeymap();
        }
        this.textComponent.setKeymap(km);
        SwingUtilities.replaceUIInputMap(this.textComponent, 0, this.getInputMap(0));
        SwingUtilities.replaceUIActionMap(this.textComponent, this.getActionMap());
    }

    InputMap getInputMap(int condition) {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        switch (condition) {
            case 2: {
                return (InputMap)defaults.get(prefix + ".windowInputMap");
            }
            case 1: {
                return (InputMap)defaults.get(prefix + ".ancestorInputMap");
            }
        }
        return (InputMap)defaults.get(prefix + ".focusInputMap");
    }

    ActionMap getActionMap() {
        String prefix = this.getPropertyPrefix();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        ActionMap am = (ActionMap)defaults.get(prefix + ".actionMap");
        if (am == null) {
            am = this.createActionMap();
            defaults.put(prefix + ".actionMap", am);
        }
        return am;
    }

    ActionMap createActionMap() {
        Action[] actions = this.textComponent.getActions();
        ActionMapUIResource am = new ActionMapUIResource();
        int i = 0;
        while (i < actions.length) {
            String name = (String)actions[i].getValue("Name");
            if (name != null) {
                am.put(name, actions[i]);
            }
            ++i;
        }
        return am;
    }

    public void uninstallUI(JComponent component) {
        super.uninstallUI(component);
        this.rootView.setView(null);
        this.textComponent.removePropertyChangeListener(this.updateHandler);
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.textComponent = null;
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallListeners() {
        this.textComponent.removeFocusListener(this.focuslistener);
    }

    protected void uninstallKeyboardActions() {
    }

    protected abstract String getPropertyPrefix();

    public Dimension getPreferredSize(JComponent c) {
        View v = this.getRootView(this.textComponent);
        float w = v.getPreferredSpan(0);
        float h = v.getPreferredSpan(1);
        return new Dimension((int)w, (int)h);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public final void paint(Graphics g, JComponent c) {
        this.paintSafely(g);
    }

    protected void paintSafely(Graphics g) {
        Caret caret = this.textComponent.getCaret();
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (this.textComponent.isOpaque()) {
            this.paintBackground(g);
        }
        if (highlighter != null && this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd()) {
            highlighter.paint(g);
        }
        this.rootView.paint(g, this.getVisibleEditorRect());
        if (caret != null && this.textComponent.hasFocus()) {
            caret.paint(g);
        }
    }

    protected void paintBackground(Graphics g) {
    }

    public void damageRange(JTextComponent t, int p0, int p1) {
        this.damageRange(t, p0, p1, null, null);
    }

    public void damageRange(JTextComponent t, int p0, int p1, Position.Bias firstBias, Position.Bias secondBias) {
    }

    public EditorKit getEditorKit(JTextComponent t) {
        return kit;
    }

    public int getNextVisualPositionFrom(JTextComponent t, int pos, Position.Bias b, int direction, Position.Bias[] biasRet) throws BadLocationException {
        return 0;
    }

    public View getRootView(JTextComponent t) {
        return this.rootView;
    }

    public Rectangle modelToView(JTextComponent t, int pos) throws BadLocationException {
        return this.modelToView(t, pos, Position.Bias.Forward);
    }

    public Rectangle modelToView(JTextComponent t, int pos, Position.Bias bias) throws BadLocationException {
        return this.rootView.modelToView(pos, this.getVisibleEditorRect(), bias).getBounds();
    }

    public int viewToModel(JTextComponent t, Point pt) {
        return this.viewToModel(t, pt, null);
    }

    public int viewToModel(JTextComponent t, Point pt, Position.Bias[] biasReturn) {
        return this.rootView.viewToModel(pt.x, pt.y, this.getVisibleEditorRect(), biasReturn);
    }

    public View create(Element elem) {
        return null;
    }

    public View create(Element elem, int p0, int p1) {
        return null;
    }

    protected Rectangle getVisibleEditorRect() {
        int width = this.textComponent.getWidth();
        int height = this.textComponent.getHeight();
        if (width <= 0 || height <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        Insets insets = this.textComponent.getInsets();
        return new Rectangle(insets.left, insets.top, width - insets.left + insets.right, height - insets.top + insets.bottom);
    }

    protected final void setView(View view) {
        this.rootView.setView(view);
        view.setParent(this.rootView);
        this.textComponent.revalidate();
        this.textComponent.repaint();
    }

    protected void modelChanged() {
        if (this.textComponent == null || this.rootView == null) {
            return;
        }
        ViewFactory factory = this.rootView.getViewFactory();
        if (factory == null) {
            return;
        }
        Document doc = this.textComponent.getDocument();
        if (doc == null) {
            return;
        }
        this.installDocumentListeners();
        Element elem = doc.getDefaultRootElement();
        if (elem == null) {
            return;
        }
        View view = factory.create(elem);
        this.setView(view);
    }

    protected void propertyChange(PropertyChangeEvent ev) {
    }

    private final /* synthetic */ void this() {
        this.rootView = new RootView();
        this.updateHandler = new PropertyChangeHandler();
        this.documentHandler = new DocumentHandler();
        this.focuslistener = new FocusListener(){

            public final void focusGained(FocusEvent e) {
                BasicTextUI.this.textComponent.repaint();
            }

            public final void focusLost(FocusEvent e) {
                BasicTextUI.this.textComponent.repaint();
            }
        };
    }

    public BasicTextUI() {
        this.this();
    }

    public static class BasicCaret
    extends DefaultCaret
    implements UIResource {
    }

    public static class BasicHighlighter
    extends DefaultHighlighter
    implements UIResource {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class RootView
    extends View {
        private View view;

        public ViewFactory getViewFactory() {
            ViewFactory factory = null;
            EditorKit editorKit = BasicTextUI.this.getEditorKit(BasicTextUI.this.getComponent());
            factory = editorKit.getViewFactory();
            if (factory == null) {
                factory = BasicTextUI.this;
            }
            return factory;
        }

        public void preferenceChanged(View view, boolean width, boolean height) {
            BasicTextUI.this.textComponent.revalidate();
        }

        public void setView(View v) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (v != null) {
                v.setParent(null);
            }
            this.view = v;
        }

        public View getView(int index) {
            return this.view;
        }

        public int getViewCount() {
            if (this.view != null) {
                return 1;
            }
            return 0;
        }

        public Container getContainer() {
            return BasicTextUI.this.textComponent;
        }

        public float getPreferredSpan(int axis) {
            if (this.view != null) {
                return this.view.getPreferredSpan(axis);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics g, Shape s) {
            if (this.view != null) {
                this.view.paint(g, s);
            }
        }

        public Shape modelToView(int position, Shape a, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(position, a, bias);
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            return this.view.viewToModel(x, y, a, b);
        }

        public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.insertUpdate(ev, shape, vf);
        }

        public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.removeUpdate(ev, shape, vf);
        }

        public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
            this.view.changedUpdate(ev, shape, vf);
        }

        public RootView() {
            super(null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("document")) {
                BasicTextUI.this.modelChanged();
            }
            BasicTextUI.this.propertyChange(event);
        }

        PropertyChangeHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DocumentHandler
    implements DocumentListener {
        public void changedUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.changedUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void insertUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.insertUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        public void removeUpdate(DocumentEvent ev) {
            BasicTextUI.this.rootView.removeUpdate(ev, BasicTextUI.this.getVisibleEditorRect(), BasicTextUI.this.rootView.getViewFactory());
        }

        DocumentHandler() {
        }
    }
}

