/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractArray;
import org.armedbear.lisp.AbstractVector;
import org.armedbear.lisp.BasicVector_UnsignedByte8;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SimpleVector;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.TypeError;

public final class ComplexVector_UnsignedByte8
extends AbstractVector {
    private int capacity;
    private int fillPointer = -1;
    private boolean isDisplaced;
    private byte[] elements;
    private AbstractArray array;
    private int displacement;

    public ComplexVector_UnsignedByte8(int capacity) {
        this.elements = new byte[capacity];
        this.capacity = capacity;
    }

    public ComplexVector_UnsignedByte8(int capacity, AbstractArray array, int displacement) {
        this.capacity = capacity;
        this.array = array;
        this.displacement = displacement;
        this.isDisplaced = true;
    }

    @Override
    public LispObject typeOf() {
        return Lisp.list(Symbol.VECTOR, Lisp.UNSIGNED_BYTE_8, Fixnum.getInstance(this.capacity));
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.VECTOR;
    }

    @Override
    public boolean hasFillPointer() {
        return this.fillPointer >= 0;
    }

    @Override
    public int getFillPointer() {
        return this.fillPointer;
    }

    @Override
    public void setFillPointer(int n) {
        this.fillPointer = n;
    }

    @Override
    public void setFillPointer(LispObject obj) {
        if (obj == Lisp.T) {
            this.fillPointer = this.capacity();
        } else {
            int n = Fixnum.getValue(obj);
            if (n > this.capacity()) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") exceeds the capacity of the vector (");
                sb.append(this.capacity());
                sb.append(").");
                Lisp.error(new LispError(sb.toString()));
            } else if (n < 0) {
                StringBuffer sb = new StringBuffer("The new fill pointer (");
                sb.append(n);
                sb.append(") is negative.");
                Lisp.error(new LispError(sb.toString()));
            } else {
                this.fillPointer = n;
            }
        }
    }

    @Override
    public boolean isDisplaced() {
        return this.isDisplaced;
    }

    @Override
    public LispObject arrayDisplacement() {
        Fixnum value2;
        LispObject value1;
        if (this.array != null) {
            value1 = this.array;
            value2 = Fixnum.getInstance(this.displacement);
        } else {
            value1 = Lisp.NIL;
            value2 = Fixnum.ZERO;
        }
        return LispThread.currentThread().setValues(value1, value2);
    }

    @Override
    public LispObject getElementType() {
        return Lisp.UNSIGNED_BYTE_8;
    }

    @Override
    public boolean isSimpleVector() {
        return false;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public int length() {
        return this.fillPointer >= 0 ? this.fillPointer : this.capacity;
    }

    @Override
    public LispObject elt(int index) {
        int limit = this.length();
        if (index < 0 || index >= limit) {
            this.badIndex(index, limit);
        }
        return this.AREF(index);
    }

    @Override
    public LispObject AREF(int index) {
        if (this.elements != null) {
            try {
                return Lisp.coerceFromJavaByte(this.elements[index]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.elements.length);
                return Lisp.NIL;
            }
        }
        if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        }
        return this.array.AREF(index + this.displacement);
    }

    @Override
    public void aset(int index, int n) {
        if (this.elements != null) {
            try {
                this.elements[index] = (byte)n;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.elements.length);
            }
        } else if (index < 0 || index >= this.capacity) {
            this.badIndex(index, this.capacity);
        } else {
            this.array.aset(index + this.displacement, n);
        }
    }

    @Override
    public void aset(int index, LispObject newValue) {
        if (this.elements != null) {
            try {
                this.elements[index] = Lisp.coerceToJavaByte(newValue);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.badIndex(index, this.elements.length);
            }
        } else {
            this.array.aset(index + this.displacement, newValue);
        }
    }

    @Override
    public LispObject subseq(int start, int end) {
        SimpleVector v = new SimpleVector(end - start);
        int i = start;
        int j = 0;
        try {
            while (i < end) {
                v.aset(j++, this.AREF(i++));
            }
            return v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return Lisp.error(new TypeError("Array index out of bounds: " + i + "."));
        }
    }

    @Override
    public void fill(LispObject obj) {
        if (!(obj instanceof Fixnum)) {
            Lisp.type_error(obj, Symbol.FIXNUM);
            return;
        }
        int n = ((Fixnum)obj).value;
        if (n < 0 || n > 255) {
            Lisp.type_error(obj, Lisp.UNSIGNED_BYTE_8);
            return;
        }
        int i = this.capacity;
        while (i-- > 0) {
            this.elements[i] = (byte)n;
        }
    }

    @Override
    public void shrink(int n) {
        if (this.elements != null) {
            if (n < this.elements.length) {
                byte[] newArray = new byte[n];
                System.arraycopy(this.elements, 0, newArray, 0, n);
                this.elements = newArray;
                this.capacity = n;
                return;
            }
            if (n == this.elements.length) {
                return;
            }
        }
        Lisp.error(new LispError());
    }

    @Override
    public LispObject reverse() {
        int length = this.length();
        BasicVector_UnsignedByte8 result = new BasicVector_UnsignedByte8(length);
        int i = 0;
        int j = length - 1;
        while (i < length) {
            result.aset(i, this.AREF(j));
            ++i;
            --j;
        }
        return result;
    }

    @Override
    public LispObject nreverse() {
        if (this.elements != null) {
            int i = 0;
            for (int j = this.length() - 1; i < j; ++i, --j) {
                byte temp = this.elements[i];
                this.elements[i] = this.elements[j];
                this.elements[j] = temp;
            }
        } else {
            int length = this.length();
            byte[] data = new byte[length];
            int i = 0;
            int j = length - 1;
            while (i < length) {
                data[i] = Lisp.coerceToJavaByte(this.AREF(j));
                ++i;
                --j;
            }
            this.elements = data;
            this.capacity = length;
            this.array = null;
            this.displacement = 0;
            this.isDisplaced = false;
            this.fillPointer = -1;
        }
        return this;
    }

    @Override
    public void vectorPushExtend(LispObject element) {
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            this.ensureCapacity(this.capacity * 2 + 1);
        }
        this.aset(this.fillPointer, element);
        ++this.fillPointer;
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element) {
        this.vectorPushExtend(element);
        return Fixnum.getInstance(this.fillPointer - 1);
    }

    @Override
    public LispObject VECTOR_PUSH_EXTEND(LispObject element, LispObject extension) {
        int ext = Fixnum.getValue(extension);
        if (this.fillPointer < 0) {
            this.noFillPointer();
        }
        if (this.fillPointer >= this.capacity) {
            ext = Math.max(ext, this.capacity + 1);
            this.ensureCapacity(this.capacity + ext);
        }
        this.aset(this.fillPointer, element);
        return Fixnum.getInstance(this.fillPointer++);
    }

    private final void ensureCapacity(int minCapacity) {
        if (this.elements != null) {
            if (this.capacity < minCapacity) {
                byte[] newArray = new byte[minCapacity];
                System.arraycopy(this.elements, 0, newArray, 0, this.capacity);
                this.elements = newArray;
                this.capacity = minCapacity;
            }
        } else {
            Debug.assertTrue(this.array != null);
            if (this.capacity < minCapacity || this.array.getTotalSize() - this.displacement < minCapacity) {
                this.elements = new byte[minCapacity];
                int limit = Math.min(this.capacity, this.array.getTotalSize() - this.displacement);
                for (int i = 0; i < limit; ++i) {
                    this.elements[i] = Lisp.coerceToJavaByte(this.array.AREF(this.displacement + i));
                }
                this.capacity = minCapacity;
                this.array = null;
                this.displacement = 0;
                this.isDisplaced = false;
            }
        }
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, LispObject initialElement, LispObject initialContents) {
        if (initialContents != null) {
            byte[] newElements = new byte[newCapacity];
            if (initialContents.listp()) {
                LispObject list = initialContents;
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = Lisp.coerceToJavaByte(list.car());
                    list = list.cdr();
                }
            } else if (initialContents.vectorp()) {
                for (int i = 0; i < newCapacity; ++i) {
                    newElements[i] = Lisp.coerceToJavaByte(initialContents.elt(i));
                }
            } else {
                Lisp.type_error(initialContents, Symbol.SEQUENCE);
            }
            this.elements = newElements;
        } else {
            int i;
            if (this.elements == null) {
                this.elements = new byte[newCapacity];
                int limit = Math.min(this.capacity, newCapacity);
                for (i = 0; i < limit; ++i) {
                    this.elements[i] = Lisp.coerceToJavaByte(this.array.AREF(this.displacement + i));
                }
            } else if (this.capacity != newCapacity) {
                byte[] newElements = new byte[newCapacity];
                System.arraycopy(this.elements, 0, newElements, 0, Math.min(this.capacity, newCapacity));
                this.elements = newElements;
            }
            if (initialElement != null) {
                byte b = Lisp.coerceToJavaByte(initialElement);
                for (i = this.capacity; i < newCapacity; ++i) {
                    this.elements[i] = b;
                }
            }
        }
        this.capacity = newCapacity;
        this.array = null;
        this.displacement = 0;
        this.isDisplaced = false;
        return this;
    }

    @Override
    public AbstractVector adjustArray(int newCapacity, AbstractArray displacedTo, int displacement) {
        this.capacity = newCapacity;
        this.array = displacedTo;
        this.displacement = displacement;
        this.elements = null;
        this.isDisplaced = true;
        return this;
    }
}

