/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Attributes {
    private static final int EXPIRATION_OVERFLOW_WARNING_INTERVAL_MINUTES = Integer.getInteger("cassandra.expiration_overflow_warning_interval_minutes", 5);
    private static final Logger logger = LoggerFactory.getLogger(Attributes.class);
    @VisibleForTesting
    public static ExpirationDateOverflowPolicy policy;
    public static final String MAXIMUM_EXPIRATION_DATE_EXCEEDED_WARNING = "Request on table {}.{} with {}ttl of {} seconds exceeds maximum supported expiration date of 2038-01-19T03:14:06+00:00 and will have its expiration capped to that date. In order to avoid this use a lower TTL or upgrade to a version where this limitation is fixed. See CASSANDRA-14092 for more details.";
    public static final String MAXIMUM_EXPIRATION_DATE_EXCEEDED_REJECT_MESSAGE = "Request on table %s.%s with %sttl of %d seconds exceeds maximum supported expiration date of 2038-01-19T03:14:06+00:00. In order to avoid this use a lower TTL, change the expiration date overflow policy or upgrade to a version where this limitation is fixed. See CASSANDRA-14092 for more details.";
    private final Term timestamp;
    private final Term timeToLive;

    public static Attributes none() {
        return new Attributes(null, null);
    }

    private Attributes(Term timestamp, Term timeToLive) {
        this.timestamp = timestamp;
        this.timeToLive = timeToLive;
    }

    public Iterable<Function> getFunctions() {
        if (this.timestamp != null && this.timeToLive != null) {
            return Iterables.concat(this.timestamp.getFunctions(), this.timeToLive.getFunctions());
        }
        if (this.timestamp != null) {
            return this.timestamp.getFunctions();
        }
        if (this.timeToLive != null) {
            return this.timeToLive.getFunctions();
        }
        return Collections.emptySet();
    }

    public boolean isTimestampSet() {
        return this.timestamp != null;
    }

    public boolean isTimeToLiveSet() {
        return this.timeToLive != null;
    }

    public long getTimestamp(long now, QueryOptions options) throws InvalidRequestException {
        if (this.timestamp == null) {
            return now;
        }
        ByteBuffer tval = this.timestamp.bindAndGet(options);
        if (tval == null) {
            throw new InvalidRequestException("Invalid null value of timestamp");
        }
        if (tval == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return now;
        }
        try {
            LongType.instance.validate(tval);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException("Invalid timestamp value: " + tval);
        }
        return (Long)LongType.instance.compose(tval);
    }

    public int getTimeToLive(QueryOptions options, CFMetaData metadata) throws InvalidRequestException {
        if (this.timeToLive == null) {
            Attributes.maybeApplyExpirationDateOverflowPolicy(metadata, metadata.getDefaultTimeToLive(), true);
            return metadata.getDefaultTimeToLive();
        }
        ByteBuffer tval = this.timeToLive.bindAndGet(options);
        if (tval == null) {
            throw new InvalidRequestException("Invalid null value of TTL");
        }
        if (tval == ByteBufferUtil.UNSET_BYTE_BUFFER) {
            return 0;
        }
        try {
            Int32Type.instance.validate(tval);
        }
        catch (MarshalException e) {
            throw new InvalidRequestException("Invalid timestamp value: " + tval);
        }
        int ttl = (Integer)Int32Type.instance.compose(tval);
        if (ttl < 0) {
            throw new InvalidRequestException("A TTL must be greater or equal to 0, but was " + ttl);
        }
        if (ttl > 630720000) {
            throw new InvalidRequestException(String.format("ttl is too large. requested (%d) maximum (%d)", ttl, 630720000));
        }
        Attributes.maybeApplyExpirationDateOverflowPolicy(metadata, ttl, false);
        return ttl;
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.timestamp != null) {
            this.timestamp.collectMarkerSpecification(boundNames);
        }
        if (this.timeToLive != null) {
            this.timeToLive.collectMarkerSpecification(boundNames);
        }
    }

    public static void maybeApplyExpirationDateOverflowPolicy(CFMetaData metadata, int ttl, boolean isDefaultTTL) throws InvalidRequestException {
        if (ttl == 0) {
            return;
        }
        int nowInSecs = (int)(System.currentTimeMillis() / 1000L);
        if (ttl + nowInSecs < 0) {
            switch (policy) {
                case CAP: {
                    NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, (long)EXPIRATION_OVERFLOW_WARNING_INTERVAL_MINUTES, TimeUnit.MINUTES, MAXIMUM_EXPIRATION_DATE_EXCEEDED_WARNING, metadata.ksName, metadata.cfName, isDefaultTTL ? "default " : "", ttl);
                    return;
                }
            }
            throw new InvalidRequestException(String.format(MAXIMUM_EXPIRATION_DATE_EXCEEDED_REJECT_MESSAGE, metadata.ksName, metadata.cfName, isDefaultTTL ? "default " : "", ttl));
        }
    }

    static {
        String policyAsString = System.getProperty("cassandra.expiration_date_overflow_policy", ExpirationDateOverflowPolicy.REJECT.name());
        try {
            policy = ExpirationDateOverflowPolicy.valueOf(policyAsString.toUpperCase());
        }
        catch (RuntimeException e) {
            logger.warn("Invalid expiration date overflow policy: {}. Using default: {}", (Object)policyAsString, (Object)ExpirationDateOverflowPolicy.REJECT.name());
            policy = ExpirationDateOverflowPolicy.REJECT;
        }
    }

    public static class Raw {
        public Term.Raw timestamp;
        public Term.Raw timeToLive;

        public Attributes prepare(String ksName, String cfName) throws InvalidRequestException {
            Term ts = this.timestamp == null ? null : this.timestamp.prepare(ksName, this.timestampReceiver(ksName, cfName));
            Term ttl = this.timeToLive == null ? null : this.timeToLive.prepare(ksName, this.timeToLiveReceiver(ksName, cfName));
            return new Attributes(ts, ttl);
        }

        private ColumnSpecification timestampReceiver(String ksName, String cfName) {
            return new ColumnSpecification(ksName, cfName, new ColumnIdentifier("[timestamp]", true), LongType.instance);
        }

        private ColumnSpecification timeToLiveReceiver(String ksName, String cfName) {
            return new ColumnSpecification(ksName, cfName, new ColumnIdentifier("[ttl]", true), Int32Type.instance);
        }
    }

    public static enum ExpirationDateOverflowPolicy {
        REJECT,
        CAP;

    }
}

