/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.netty.util.concurrent;

import com.datastax.shaded.netty.util.concurrent.Future;
import com.datastax.shaded.netty.util.concurrent.GenericFutureListener;
import com.datastax.shaded.netty.util.concurrent.Promise;
import com.datastax.shaded.netty.util.internal.ObjectUtil;
import com.datastax.shaded.netty.util.internal.logging.InternalLogger;
import com.datastax.shaded.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promises) {
        ObjectUtil.checkNotNull(promises, "promises");
        for (Promise<? super V> promise : promises) {
            if (promise != null) continue;
            throw new IllegalArgumentException("promises contains null Promise");
        }
        this.promises = (Promise[])promises.clone();
    }

    @Override
    public void operationComplete(F future) throws Exception {
        if (future.isSuccess()) {
            Object result = future.get();
            for (Promise promise : this.promises) {
                if (promise.trySuccess(result)) continue;
                logger.warn("Failed to mark a promise as success because it is done already: {}", (Object)promise);
            }
            return;
        }
        Throwable cause = future.cause();
        for (Promise<V> promise : this.promises) {
            if (promise.tryFailure(cause)) continue;
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }
}

