/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.ValueRow;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;
    private int firstColumn = -1;
    private int[] generatedColumnPositions;
    private DataValueDescriptor[] normalizedGeneratedValues;

    NoRowsResultSetImpl(Activation activation) {
        this.activation = activation;
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        this.isOpen = true;
        StatementContext statementContext = this.lcc.getStatementContext();
        statementContext.setTopResultSet(this, this.subqueryTrackingArray);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
        }
    }

    public final boolean returnsRows() {
        return false;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public ResultDescription getResultDescription() {
        return null;
    }

    public final Activation getActivation() {
        return this.activation;
    }

    public final ExecRow getAbsoluteRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    public final ExecRow getRelativeRow(int n) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    public final ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    public final ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    public final ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    public final ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    public final ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    public final ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    public final void clearCurrentRow() {
    }

    public final boolean checkRowPosition(int n) {
        return false;
    }

    public final int getRowNumber() {
        return 0;
    }

    public void close() throws StandardException {
        if (!this.isOpen) {
            return;
        }
        if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit() && !this.activation.isClosed() && !this.lcc.getStatementContext().getStatementWasInvalidated()) {
            this.endExecutionTime = this.getCurrentTimeMillis();
            ResultSetStatisticsFactory resultSetStatisticsFactory = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getResultSetStatisticsFactory();
            RunTimeStatistics runTimeStatistics = resultSetStatisticsFactory.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray);
            this.lcc.setRunTimeStatisticsObject(runTimeStatistics);
            XPLAINVisitor xPLAINVisitor = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getXPLAINFactory().getXPLAINVisitor();
            xPLAINVisitor.doXPLAIN(runTimeStatistics, this.activation);
        }
        int n = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.subqueryTrackingArray[i] == null || this.subqueryTrackingArray[i].isClosed()) continue;
            this.subqueryTrackingArray[i].close();
        }
        this.isOpen = false;
        if (this.activation.isSingleExecution()) {
            this.activation.close();
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
    }

    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int n) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    public long getTimeSpent(int n) {
        return 0L;
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int n) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[n];
        }
        return this.subqueryTrackingArray;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static void evaluateACheckConstraint(GeneratedMethod generatedMethod, String string, long l, Activation activation) throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        if (generatedMethod != null && (dataValueDescriptor = (DataValueDescriptor)generatedMethod.invoke(activation)) != null && !dataValueDescriptor.isNull() && !dataValueDescriptor.getBoolean()) {
            DataDictionary dataDictionary = activation.getLanguageConnectionContext().getDataDictionary();
            ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(l);
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(conglomerateDescriptor.getTableID());
            StandardException standardException = StandardException.newException("23513", (Object)tableDescriptor.getQualifiedName(), (Object)string);
            throw standardException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void evaluateGenerationClauses(GeneratedMethod generatedMethod, Activation activation, NoPutResultSet noPutResultSet, ExecRow execRow, boolean bl) throws StandardException {
        ExecRow execRow2;
        block6: {
            if (generatedMethod == null) return;
            execRow2 = (ExecRow)activation.getCurrentRow(noPutResultSet.resultSetNumber());
            try {
                noPutResultSet.setCurrentRow(execRow);
                generatedMethod.invoke(activation);
                if (this.firstColumn < 0) {
                    this.firstColumn = NormalizeResultSet.computeStartColumn(bl, activation.getResultDescription());
                }
                if (this.generatedColumnPositions == null) {
                    this.setupGeneratedColumns(activation, (ValueRow)execRow);
                }
                ResultDescription resultDescription = activation.getResultDescription();
                int n = this.generatedColumnPositions.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = this.generatedColumnPositions[i];
                    DataValueDescriptor dataValueDescriptor = NormalizeResultSet.normalizeColumn(resultDescription.getColumnDescriptor(n2).getType(), execRow, n2, this.normalizedGeneratedValues[i], resultDescription);
                    execRow.setColumn(n2, dataValueDescriptor);
                }
                Object var13_12 = null;
                if (execRow2 != null) break block6;
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                if (execRow2 == null) {
                    noPutResultSet.clearCurrentRow();
                    throw throwable;
                }
                noPutResultSet.setCurrentRow(execRow2);
                throw throwable;
            }
            noPutResultSet.clearCurrentRow();
            return;
        }
        noPutResultSet.setCurrentRow(execRow2);
    }

    private void setupGeneratedColumns(Activation activation, ValueRow valueRow) throws StandardException {
        int n;
        ResultDescription resultDescription = activation.getResultDescription();
        int n2 = resultDescription.getColumnCount();
        ExecRow execRow = valueRow.getNewNullRow();
        int n3 = 0;
        for (n = 1; n <= n2; ++n) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (n < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(n)).hasGenerationClause()) continue;
            ++n3;
        }
        this.generatedColumnPositions = new int[n3];
        this.normalizedGeneratedValues = new DataValueDescriptor[n3];
        n = 0;
        for (int i = 1; i <= n2; ++i) {
            ResultColumnDescriptor resultColumnDescriptor;
            if (i < this.firstColumn || !(resultColumnDescriptor = resultDescription.getColumnDescriptor(i)).hasGenerationClause()) continue;
            this.generatedColumnPositions[n] = i;
            this.normalizedGeneratedValues[n] = execRow.getColumn(i);
            ++n;
        }
    }

    public static void evaluateCheckConstraints(GeneratedMethod generatedMethod, Activation activation) throws StandardException {
        if (generatedMethod != null) {
            generatedMethod.invoke(activation);
        }
    }

    public boolean doesCommit() {
        return false;
    }

    public void addWarning(SQLWarning sQLWarning) {
        this.getActivation().addWarning(sQLWarning);
    }

    public SQLWarning getWarnings() {
        return null;
    }
}

