/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Function;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.CollectPreconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Collections2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.ImmutableEntry;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$1;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$2;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$3;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$7;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$8;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.Maps$EntryFunction;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class Maps {
    static Function valueFunction() {
        return Maps$EntryFunction.VALUE;
    }

    static Iterator keyIterator(Iterator iterator) {
        return new Maps$1(iterator);
    }

    static Iterator valueIterator(Iterator iterator) {
        return new Maps$2(iterator);
    }

    public static HashMap newHashMap() {
        return new HashMap();
    }

    public static HashMap newHashMapWithExpectedSize(int n) {
        return new HashMap(Maps.capacity(n));
    }

    static int capacity(int n) {
        if (n < 3) {
            CollectPreconditions.checkNonnegative(n, "expectedSize");
            return n + 1;
        }
        if (n < 0x40000000) {
            return (int)((float)n / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static ConcurrentMap newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    static Iterator asMapEntryIterator(Set set, Function function) {
        return new Maps$3(set.iterator(), function);
    }

    public static Map.Entry immutableEntry(@NullableDecl Object object, @NullableDecl Object object2) {
        return new ImmutableEntry(object, object2);
    }

    static Map.Entry unmodifiableEntry(Map.Entry entry) {
        Preconditions.checkNotNull(entry);
        return new Maps$7(entry);
    }

    static UnmodifiableIterator unmodifiableEntryIterator(Iterator iterator) {
        return new Maps$8(iterator);
    }

    static Object safeGet(Map map, @NullableDecl Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.get(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    static boolean safeContainsKey(Map map, Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.containsKey(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    static Object safeRemove(Map map, Object object) {
        Preconditions.checkNotNull(map);
        try {
            return map.remove(object);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    static boolean containsEntryImpl(Collection collection, Object object) {
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        return collection.contains(Maps.unmodifiableEntry((Map.Entry)object));
    }

    static boolean equalsImpl(Map map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            Map map2 = (Map)object;
            return map.entrySet().equals(map2.entrySet());
        }
        return false;
    }

    static String toStringImpl(Map map) {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean bl = true;
        for (Map.Entry entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            bl = false;
            stringBuilder.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return stringBuilder.append('}').toString();
    }

    @NullableDecl
    static Object keyOrNull(@NullableDecl Map.Entry entry) {
        return entry == null ? null : entry.getKey();
    }

    @NullableDecl
    static Object valueOrNull(@NullableDecl Map.Entry entry) {
        return entry == null ? null : entry.getValue();
    }
}

