/*
 * AppleRecords - A DAAP client
 * Copyright (C) 2004  Chris Davies <c.davies@cdavies.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

package org.cdavies.applerecords;

import javax.swing.*;
import java.awt.event.*;
import java.util.*;

import org.cdavies.applerecords.table.*;
import org.cdavies.itunes.*;

import javazoom.jl.player.*;

public class ServerControlActionListener implements ActionListener {
	
	private TrackListTableModel _model;
	private JTable _table;
	private AppleRecordsStatusPanel _status;
	private AppleRecordsControlPanel _controls;
	
	public ServerControlActionListener(TrackListTableModel model, JTable table, AppleRecordsStatusPanel status, AppleRecordsControlPanel controls) {
		
		_model = model;
		_table = table;
		_status = status;
		_controls = controls;
		
	}
	
	public void actionPerformed(ActionEvent e) {
		
		_controls.noNextTrack();
		AppleRecordsServerControl _servControl = (AppleRecordsServerControl)e.getSource();
		
		ItunesConnection _conn = (ItunesConnection)_servControl.getSelectedItem();
		
		_status.setTimedText("Browsing '" + _conn.toString() + "'");
		
		Track[] _t = _conn.getTracklist(_conn.getDatabases()[0].getId());
		
		Arrays.sort(_t, new TrackComparator());
		
		_model.clear();
		
		for (int _i = 0; _i < _t.length; _i++)
			_model.addRow(_t[_i]);
		
		_table.addNotify();
		_table.validate();
		_table.repaint();
		
		
	}
	
}

