/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.align;

import edu.umd.marbl.mhap.align.AlignElement;
import edu.umd.marbl.mhap.align.Aligner;
import edu.umd.marbl.mhap.align.Alignment;
import edu.umd.marbl.mhap.impl.OverlapInfo;
import edu.umd.marbl.mhap.sketch.Sketch;

public final class AlignElementDoubleSketch<T extends Sketch<T>>
implements AlignElement<AlignElementDoubleSketch<T>> {
    private final T[] elements;
    private final int seqLength;
    private final int stepSize;

    public AlignElementDoubleSketch(T[] sketchArray, int stepSize, int seqLength) {
        this.elements = sketchArray;
        this.stepSize = stepSize;
        this.seqLength = seqLength;
    }

    public OverlapInfo getOverlapInfo(Aligner<AlignElementDoubleSketch<T>> aligner, AlignElementDoubleSketch<T> b) {
        Alignment<AlignElementDoubleSketch<T>> alignment = this.localAlignOneSkip(aligner, b);
        int a1 = alignment.getA1() * 2;
        int a2 = alignment.getA2() * 2;
        int b1 = alignment.getB1() * 2;
        int b2 = alignment.getB2() * 2;
        if (alignment.getScore() < 0.0) {
            return new OverlapInfo(0.0, 0.0, a1, a2, b1, b2);
        }
        int offsetStart = this.similarityOffset(b, alignment.getA1(), alignment.getB1());
        int offsetEnd = this.similarityOffset(b, alignment.getA2(), alignment.getB2());
        if (offsetStart > 0) {
            ++a1;
        } else if (offsetStart < 0) {
            ++b1;
        }
        if (offsetEnd > 0) {
            ++a2;
        } else if (offsetEnd < 0) {
            ++b2;
        }
        a2 = Math.min(this.getSequenceLength() - 1, a2 * this.stepSize + this.stepSize - 1);
        b2 = Math.min(b.getSequenceLength() - 1, b2 * b.stepSize + b.stepSize - 1);
        double score = alignment.getScore();
        return new OverlapInfo(score / 100000.0, score, a1 *= this.stepSize, a2, b1 *= b.stepSize, b2);
    }

    public int getSequenceLength() {
        return this.seqLength;
    }

    public T getSketch(int index) {
        return this.elements[index];
    }

    public int getStepSize() {
        return this.stepSize;
    }

    @Override
    public int length() {
        int val = this.elements.length / 2;
        if (this.elements.length % 2 != 0) {
            ++val;
        }
        return val;
    }

    public Alignment<AlignElementDoubleSketch<T>> localAlignOneSkip(Aligner<AlignElementDoubleSketch<T>> aligner, AlignElementDoubleSketch<T> b) {
        return aligner.localAlignOneSkip(this, b);
    }

    @Override
    public double similarityScore(AlignElementDoubleSketch<T> e, int i, int j) {
        double max = this.elements[2 * i].similarity(e.elements[2 * j]);
        if (2 * i + 1 < this.elements.length) {
            max = Math.max(max, this.elements[2 * i + 1].similarity(e.elements[2 * j]));
        }
        if (2 * j + 1 < e.elements.length) {
            max = Math.max(max, this.elements[2 * i].similarity(e.elements[2 * j + 1]));
        }
        return max;
    }

    private int similarityOffset(AlignElementDoubleSketch<T> e, int i, int j) {
        double val;
        double max = this.elements[2 * i].similarity(e.elements[2 * j]);
        int diff = 0;
        if (2 * i + 1 < this.elements.length && max < (val = this.elements[2 * i + 1].similarity(e.elements[2 * j]))) {
            max = val;
            diff = 1;
        }
        if (2 * j + 1 < e.elements.length && max < (val = this.elements[2 * i].similarity(e.elements[2 * j + 1]))) {
            max = val;
            diff = -1;
        }
        return diff;
    }

    @Override
    public String toString(AlignElementDoubleSketch<T> match, int i, int j) {
        return this.toString();
    }

    @Override
    public String toString(int i) {
        return this.elements[i].toString();
    }
}

