/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.impl;

import edu.umd.marbl.mhap.impl.AbstractMatchSearch;
import edu.umd.marbl.mhap.impl.MatchResult;
import edu.umd.marbl.mhap.impl.MhapRuntimeException;
import edu.umd.marbl.mhap.impl.OverlapInfo;
import edu.umd.marbl.mhap.impl.SequenceId;
import edu.umd.marbl.mhap.impl.SequenceSketch;
import edu.umd.marbl.mhap.impl.SequenceSketchStreamer;
import edu.umd.marbl.mhap.sketch.MinHashSketch;
import edu.umd.marbl.mhap.utils.HitCounter;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class MinHashSearch
extends AbstractMatchSearch {
    private final double acceptScore;
    private final ArrayList<Map<Integer, ArrayList<SequenceId>>> hashes;
    private final double maxShift;
    private final AtomicLong minhashSearchTime;
    private final AtomicLong sortMergeSearchTime;
    private final int minStoreLength;
    private final AtomicLong numberElementsProcessed;
    private final AtomicLong numberSequencesFullyCompared;
    private final AtomicLong numberSequencesHit;
    private final AtomicLong numberSequencesMinHashed;
    private final int numMinMatches;
    private final Map<SequenceId, SequenceSketch> sequenceVectorsHash;

    public MinHashSearch(SequenceSketchStreamer data, int numHashes, int numMinMatches, int numThreads, boolean storeResults, int minStoreLength, double maxShift, double acceptScore, boolean doReverseCompliment) throws IOException {
        super(numThreads, storeResults);
        this.minStoreLength = minStoreLength;
        this.numMinMatches = numMinMatches;
        this.maxShift = maxShift;
        this.acceptScore = acceptScore;
        this.numberSequencesHit = new AtomicLong();
        this.numberSequencesFullyCompared = new AtomicLong();
        this.numberSequencesMinHashed = new AtomicLong();
        this.numberElementsProcessed = new AtomicLong();
        this.minhashSearchTime = new AtomicLong();
        this.sortMergeSearchTime = new AtomicLong();
        data.enqueueFullFile(false, this.numThreads);
        this.sequenceVectorsHash = new Object2ObjectOpenHashMap<SequenceId, SequenceSketch>(data.getNumberProcessed());
        this.hashes = new ArrayList(numHashes);
        for (int iter = 0; iter < numHashes; ++iter) {
            Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap(data.getNumberProcessed());
            this.hashes.add(map);
        }
        this.addData(data, doReverseCompliment);
        System.err.println("Stored " + this.sequenceVectorsHash.size() + " sequences in the index.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addSequence(SequenceSketch currHash) {
        int[] currMinHashes = currHash.getMinHashes().getMinHashArray();
        if (currMinHashes.length != this.hashes.size()) {
            throw new MhapRuntimeException("Number of MinHashes of the sequence does not match current settings.");
        }
        Map<SequenceId, SequenceSketch> map = this.sequenceVectorsHash;
        synchronized (map) {
            SequenceSketch minHash = this.sequenceVectorsHash.put(currHash.getSequenceId(), currHash);
            if (minHash != null) {
                this.sequenceVectorsHash.put(currHash.getSequenceId(), minHash);
                throw new MhapRuntimeException("Sequence ID already exists in the hash table.");
            }
        }
        int count = 0;
        SequenceId id = currHash.getSequenceId();
        for (Map<Integer, ArrayList<SequenceId>> hash : this.hashes) {
            ArrayList currList;
            int hashVal = currMinHashes[count];
            Object object = hash;
            synchronized (object) {
                currList = hash.computeIfAbsent(hashVal, k -> new ArrayList(2));
            }
            object = currList;
            synchronized (object) {
                currList.add(id);
            }
            ++count;
        }
        this.numberSequencesMinHashed.getAndIncrement();
        return true;
    }

    @Override
    public List<MatchResult> findMatches(SequenceSketch seqHashes, boolean toSelf) {
        long startTime = System.nanoTime();
        MinHashSketch minHash = seqHashes.getMinHashes();
        if (this.hashes.size() != minHash.numHashes()) {
            throw new MhapRuntimeException("Number of hashes does not match. Stored size " + this.hashes.size() + ", input size " + minHash.numHashes() + ".");
        }
        Object2ObjectOpenHashMap<SequenceId, HitCounter> bestSequenceHit = new Object2ObjectOpenHashMap<SequenceId, HitCounter>(256);
        int[] minHashes = minHash.getMinHashArray();
        int hashIndex = 0;
        long additionalProcessed = 0L;
        for (Map<Integer, ArrayList<SequenceId>> currHash : this.hashes) {
            ArrayList<SequenceId> currentHashMatchList = currHash.get(minHashes[hashIndex]);
            if (currentHashMatchList != null) {
                additionalProcessed += (long)currentHashMatchList.size();
                for (SequenceId sequenceId : currentHashMatchList) {
                    bestSequenceHit.compute(sequenceId, (k, v) -> v == null ? new HitCounter(1) : v.addHit());
                }
            }
            ++hashIndex;
        }
        long minHashEndTime = System.nanoTime();
        this.minhashSearchTime.getAndAdd(minHashEndTime - startTime);
        this.numberElementsProcessed.getAndAdd(additionalProcessed);
        this.numberSequencesHit.getAndAdd(bestSequenceHit.size());
        ArrayList<MatchResult> matches = new ArrayList<MatchResult>(32);
        for (Map.Entry entry : bestSequenceHit.entrySet()) {
            SequenceId matchId = (SequenceId)entry.getKey();
            if (toSelf && matchId.getHeaderId() == seqHashes.getSequenceId().getHeaderId() || ((HitCounter)entry.getValue()).count < this.numMinMatches) continue;
            SequenceSketch matchedHashes = this.sequenceVectorsHash.get(entry.getKey());
            if (matchedHashes == null) {
                throw new MhapRuntimeException("Hashes not found for given id.");
            }
            if (matchedHashes.getSequenceLength() < this.minStoreLength && seqHashes.getSequenceLength() < this.minStoreLength || toSelf && matchId.getHeaderId() > seqHashes.getSequenceId().getHeaderId() && matchedHashes.getSequenceLength() >= this.minStoreLength && seqHashes.getSequenceLength() >= this.minStoreLength || toSelf && matchedHashes.getSequenceLength() < this.minStoreLength && seqHashes.getSequenceLength() >= this.minStoreLength) continue;
            OverlapInfo result = seqHashes.getOrderedHashes().getOverlapInfo(matchedHashes.getOrderedHashes(), this.maxShift);
            boolean accept = result.score >= this.acceptScore;
            this.numberSequencesFullyCompared.getAndIncrement();
            if (!accept) continue;
            MatchResult currResult = new MatchResult(seqHashes.getSequenceId(), matchId, result, seqHashes.getSequenceLength(), matchedHashes.getSequenceLength());
            matches.add(currResult);
        }
        long endTime = System.nanoTime();
        this.sortMergeSearchTime.getAndAdd(endTime - minHashEndTime);
        return matches;
    }

    public double getMinHashSearchTime() {
        return (double)this.minhashSearchTime.longValue() * 1.0E-9;
    }

    public double getSortMergeTime() {
        return (double)this.sortMergeSearchTime.longValue() * 1.0E-9;
    }

    public long getNumberElementsProcessed() {
        return this.numberElementsProcessed.get();
    }

    public long getNumberSequenceHashed() {
        return this.numberSequencesMinHashed.get();
    }

    public long getNumberSequencesFullyCompared() {
        return this.numberSequencesFullyCompared.get();
    }

    public long getNumberSequencesHit() {
        return this.numberSequencesHit.get();
    }

    @Override
    public List<SequenceId> getStoredForwardSequenceIds() {
        ArrayList<SequenceId> seqIds = new ArrayList<SequenceId>(this.sequenceVectorsHash.size());
        for (SequenceSketch hashes : this.sequenceVectorsHash.values()) {
            if (!hashes.getSequenceId().isForward()) continue;
            seqIds.add(hashes.getSequenceId());
        }
        return seqIds;
    }

    @Override
    public SequenceSketch getStoredSequenceHash(SequenceId id) {
        return this.sequenceVectorsHash.get(id);
    }

    @Override
    public int size() {
        return this.sequenceVectorsHash.size();
    }
}

