/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.PayloadItem;
import org.jivesoftware.smackx.pubsub.SimplePayload;

public class ItemProvider
extends ExtensionElementProvider<Item> {
    public Item parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String id = parser.getAttributeValue(null, "id");
        String node = parser.getAttributeValue(null, "node");
        String xmlns = parser.getNamespace();
        Item.ItemNamespace itemNamespace = Item.ItemNamespace.fromXmlns(xmlns);
        XmlPullParser.TagEvent event = parser.nextTag();
        switch (event) {
            case START_ELEMENT: {
                String payloadElemName = parser.getName();
                String payloadNS = parser.getNamespace();
                ExtensionElementProvider extensionProvider = ProviderManager.getExtensionProvider((String)payloadElemName, (String)payloadNS);
                if (extensionProvider == null) {
                    CharSequence payloadText = PacketParserUtils.parseElement((XmlPullParser)parser, (boolean)true);
                    return new PayloadItem<SimplePayload>(itemNamespace, id, node, new SimplePayload(payloadText.toString()));
                }
                return new PayloadItem<ExtensionElement>(itemNamespace, id, node, (ExtensionElement)extensionProvider.parse(parser));
            }
            case END_ELEMENT: {
                return new Item(itemNamespace, id, node);
            }
        }
        throw new AssertionError((Object)("unknown: " + event));
    }
}

