/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.CommonFields;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.utils.CollectionUtils;

public class OffsetFetchResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String COMMIT_OFFSET_KEY_NAME = "offset";
    private static final String METADATA_KEY_NAME = "metadata";
    private static final Schema OFFSET_FETCH_RESPONSE_PARTITION_V0 = new Schema(CommonFields.PARTITION_ID, new Field("offset", Type.INT64, "Last committed message offset."), new Field("metadata", Type.NULLABLE_STRING, "Any associated metadata the client wants to keep."), CommonFields.ERROR_CODE);
    private static final Schema OFFSET_FETCH_RESPONSE_TOPIC_V0 = new Schema(CommonFields.TOPIC_NAME, new Field("partition_responses", new ArrayOf(OFFSET_FETCH_RESPONSE_PARTITION_V0)));
    private static final Schema OFFSET_FETCH_RESPONSE_V0;
    private static final Schema OFFSET_FETCH_RESPONSE_V1;
    private static final Schema OFFSET_FETCH_RESPONSE_V2;
    private static final Schema OFFSET_FETCH_RESPONSE_V3;
    public static final long INVALID_OFFSET = -1L;
    public static final String NO_METADATA = "";
    public static final PartitionData UNKNOWN_PARTITION;
    public static final PartitionData UNAUTHORIZED_PARTITION;
    private static final List<Errors> PARTITION_ERRORS;
    private final Map<TopicPartition, PartitionData> responseData;
    private final Errors error;
    private final int throttleTimeMs;

    public static Schema[] schemaVersions() {
        return new Schema[]{OFFSET_FETCH_RESPONSE_V0, OFFSET_FETCH_RESPONSE_V1, OFFSET_FETCH_RESPONSE_V2, OFFSET_FETCH_RESPONSE_V3};
    }

    public OffsetFetchResponse(Errors error, Map<TopicPartition, PartitionData> responseData) {
        this(0, error, responseData);
    }

    public OffsetFetchResponse(int throttleTimeMs, Errors error, Map<TopicPartition, PartitionData> responseData) {
        this.throttleTimeMs = throttleTimeMs;
        this.responseData = responseData;
        this.error = error;
    }

    public OffsetFetchResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        Errors topLevelError = Errors.NONE;
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.get(CommonFields.TOPIC_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.get(CommonFields.PARTITION_ID);
                long offset = partitionResponse.getLong(COMMIT_OFFSET_KEY_NAME);
                String metadata = partitionResponse.getString(METADATA_KEY_NAME);
                Errors error = Errors.forCode(partitionResponse.get(CommonFields.ERROR_CODE));
                if (error != Errors.NONE && !PARTITION_ERRORS.contains((Object)error)) {
                    topLevelError = error;
                }
                PartitionData partitionData = new PartitionData(offset, metadata, error);
                this.responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
        this.error = struct.hasField(CommonFields.ERROR_CODE) ? Errors.forCode(struct.get(CommonFields.ERROR_CODE)) : topLevelError;
    }

    public void maybeThrowFirstPartitionError() {
        Collection<PartitionData> partitionsData = this.responseData.values();
        for (PartitionData data : partitionsData) {
            if (!data.hasError()) continue;
            throw data.error.exception();
        }
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public boolean hasError() {
        return this.error != Errors.NONE;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public static OffsetFetchResponse parse(ByteBuffer buffer, short version) {
        return new OffsetFetchResponse(ApiKeys.OFFSET_FETCH.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.OFFSET_FETCH.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(this.responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> entries : topicsData.entrySet()) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(CommonFields.TOPIC_NAME, entries.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : entries.getValue().entrySet()) {
                PartitionData fetchPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(CommonFields.PARTITION_ID, partitionEntry.getKey());
                partitionData.set(COMMIT_OFFSET_KEY_NAME, (Object)fetchPartitionData.offset);
                partitionData.set(METADATA_KEY_NAME, (Object)fetchPartitionData.metadata);
                partitionData.set(CommonFields.ERROR_CODE, fetchPartitionData.error.code());
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        if (version > 1) {
            struct.set(CommonFields.ERROR_CODE, this.error.code());
        }
        return struct;
    }

    static {
        OFFSET_FETCH_RESPONSE_V1 = OFFSET_FETCH_RESPONSE_V0 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(OFFSET_FETCH_RESPONSE_TOPIC_V0)));
        OFFSET_FETCH_RESPONSE_V2 = new Schema(new Field(RESPONSES_KEY_NAME, new ArrayOf(OFFSET_FETCH_RESPONSE_TOPIC_V0)), CommonFields.ERROR_CODE);
        OFFSET_FETCH_RESPONSE_V3 = new Schema(CommonFields.THROTTLE_TIME_MS, new Field(RESPONSES_KEY_NAME, new ArrayOf(OFFSET_FETCH_RESPONSE_TOPIC_V0)), CommonFields.ERROR_CODE);
        UNKNOWN_PARTITION = new PartitionData(-1L, NO_METADATA, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        UNAUTHORIZED_PARTITION = new PartitionData(-1L, NO_METADATA, Errors.TOPIC_AUTHORIZATION_FAILED);
        PARTITION_ERRORS = Collections.singletonList(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    public static final class PartitionData {
        public final long offset;
        public final String metadata;
        public final Errors error;

        public PartitionData(long offset, String metadata, Errors error) {
            this.offset = offset;
            this.metadata = metadata;
            this.error = error;
        }

        public boolean hasError() {
            return this.error != Errors.NONE;
        }
    }
}

