/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.analysis.uue;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.analysis.FileAnalyzerFactory;
import org.opensolaris.opengrok.analysis.StreamSource;
import org.opensolaris.opengrok.analysis.TextAnalyzer;
import org.opensolaris.opengrok.analysis.uue.UuencodeFullTokenizer;
import org.opensolaris.opengrok.analysis.uue.UuencodeXref;
import org.opensolaris.opengrok.configuration.Project;
import org.opensolaris.opengrok.history.Annotation;

public class UuencodeAnalyzer
extends TextAnalyzer {
    private UuencodeXref xref;

    protected UuencodeAnalyzer(FileAnalyzerFactory factory) {
        super(factory);
    }

    @Override
    public void analyze(Document doc, StreamSource src, Writer xrefOut) throws IOException {
        doc.add((IndexableField)new TextField("full", this.getReader(src.getStream())));
        if (xrefOut != null) {
            try (Reader in = this.getReader(src.getStream());){
                this.writeXref(in, xrefOut);
            }
        }
    }

    @Override
    public Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        if ("full".equals(fieldName)) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new UuencodeFullTokenizer(reader));
        }
        return super.createComponents(fieldName, reader);
    }

    private void writeXref(Reader in, Writer out) throws IOException {
        if (this.xref == null) {
            this.xref = new UuencodeXref(in);
        } else {
            this.xref.reInit(in);
        }
        this.xref.project = this.project;
        this.xref.write(out);
    }

    static void writeXref(Reader in, Writer out, Definitions defs, Annotation annotation, Project project) throws IOException {
        UuencodeXref xref = new UuencodeXref(in);
        xref.annotation = annotation;
        xref.project = project;
        xref.setDefs(defs);
        xref.write(out);
    }
}

